/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class ScriptFieldsFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.hasScriptFields()) {
            return;
        }
        for (ScriptFieldsContext.ScriptField scriptField : context.scriptFields().fields()) {
            DocumentField hitField;
            Object value;
            SearchScript leafScript;
            try {
                leafScript = scriptField.script().newInstance(hitContext.readerContext());
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to load script", e1);
            }
            leafScript.setDocument(hitContext.docId());
            try {
                value = leafScript.run();
            }
            catch (RuntimeException e) {
                if (scriptField.ignoreException()) continue;
                throw e;
            }
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, DocumentField>(2));
            }
            if ((hitField = hitContext.hit().getFields().get(scriptField.name())) != null) continue;
            List<Object> values = value instanceof Collection ? new ArrayList<Object>((Collection)value) : Collections.singletonList(value);
            hitField = new DocumentField(scriptField.name(), values);
            hitContext.hit().getFields().put(scriptField.name(), hitField);
        }
    }
}

