/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import java.io.File;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.tasks.internal.XcodeSchemeFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

@Incubating
public class GenerateSchemeFileTask
extends XmlGeneratorTask<XcodeSchemeFile> {
    public DefaultXcodeProject xcodeProject;

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }

    protected void configure(XcodeSchemeFile schemeFile) {
        this.configureBuildAction(schemeFile.getBuildAction());
        this.configureTestAction(schemeFile.getTestAction());
        this.configureLaunchAction(schemeFile.getLaunchAction());
        this.configureArchiveAction(schemeFile.getArchiveAction());
        this.configureAnalyzeAction(schemeFile.getAnalyzeAction());
        this.configureProfileAction(schemeFile.getProfileAction());
    }

    private void configureBuildAction(XcodeSchemeFile.BuildAction action) {
        for (final XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            action.entry(new Action<XcodeSchemeFile.BuildActionEntry>(){

                public void execute(XcodeSchemeFile.BuildActionEntry buildActionEntry) {
                    buildActionEntry.setBuildForAnalysing(!PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType()));
                    buildActionEntry.setBuildForArchiving(!PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType()));
                    buildActionEntry.setBuildForProfiling(!PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType()));
                    buildActionEntry.setBuildForRunning(!PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType()));
                    buildActionEntry.setBuildForTesting(PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType()));
                    buildActionEntry.setBuildableReference(GenerateSchemeFileTask.this.toBuildableReference(xcodeTarget));
                }
            });
        }
    }

    private void configureTestAction(XcodeSchemeFile.TestAction action) {
        action.setBuildConfiguration("Debug");
        for (final XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            if (!PBXTarget.ProductType.UNIT_TEST.equals((Object)xcodeTarget.getProductType())) continue;
            action.setBuildConfiguration("__GradleTestRunner_Debug");
            action.entry(new Action<XcodeSchemeFile.TestableEntry>(){

                public void execute(XcodeSchemeFile.TestableEntry testableEntry) {
                    testableEntry.setSkipped(false);
                    XcodeSchemeFile.BuildableReference buildableReference = GenerateSchemeFileTask.this.toBuildableReference(xcodeTarget);
                    testableEntry.setBuildableReference(buildableReference);
                }
            });
        }
    }

    private void configureLaunchAction(XcodeSchemeFile.LaunchAction action) {
        block0: {
            action.setBuildConfiguration("Debug");
            Iterator<XcodeTarget> i$ = this.xcodeProject.getTargets().iterator();
            if (!i$.hasNext()) break block0;
            XcodeTarget xcodeTarget = i$.next();
            XcodeSchemeFile.BuildableReference buildableReference = this.toBuildableReference(xcodeTarget);
            action.setBuildableProductRunnable(buildableReference);
            action.setBuildableReference(buildableReference);
        }
    }

    private void configureArchiveAction(XcodeSchemeFile.ArchiveAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureProfileAction(XcodeSchemeFile.ProfileAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureAnalyzeAction(XcodeSchemeFile.AnalyzeAction action) {
        action.setBuildConfiguration("Debug");
    }

    public File getInputFile() {
        return null;
    }

    protected XcodeSchemeFile create() {
        return new XcodeSchemeFile(this.getXmlTransformer());
    }

    private XcodeSchemeFile.BuildableReference toBuildableReference(XcodeTarget target) {
        XcodeSchemeFile.BuildableReference buildableReference = new XcodeSchemeFile.BuildableReference();
        buildableReference.setBuildableIdentifier("primary");
        buildableReference.setBlueprintIdentifier(target.getId());
        buildableReference.setBuildableName(target.getProductName());
        buildableReference.setBlueprintName(target.getName());
        buildableReference.setContainerRelativePath(this.getProject().getName() + ".xcodeproj");
        return buildableReference;
    }
}

