/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.FindBugs;
import org.gradle.api.plugins.quality.FindBugsExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;

public class FindBugsPlugin
extends AbstractCodeQualityPlugin<FindBugs> {
    public static final String DEFAULT_FINDBUGS_VERSION = "3.0.1";
    private FindBugsExtension extension;

    @Override
    protected String getToolName() {
        return "FindBugs";
    }

    @Override
    protected Class<FindBugs> getTaskType() {
        return FindBugs.class;
    }

    @Override
    protected void beforeApply() {
        this.configureFindBugsConfigurations();
    }

    private void configureFindBugsConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create("findbugsPlugins");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The FindBugs plugins to be used for this project.");
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (FindBugsExtension)this.project.getExtensions().create("findbugs", FindBugsExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_FINDBUGS_VERSION);
        return this.extension;
    }

    @Override
    protected void configureTaskDefaults(FindBugs task, String baseName) {
        task.setPluginClasspath((FileCollection)this.project.getConfigurations().getAt("findbugsPlugins"));
        Configuration configuration = this.project.getConfigurations().getAt("findbugs");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)FindBugsPlugin.this.project.getDependencies().create((Object)("com.google.code.findbugs:findbugs:" + FindBugsPlugin.this.extension.getToolVersion())));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, FindBugs task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("findbugsClasspath", Callables.returning((Object)configuration));
        taskMapping.map("ignoreFailures", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return FindBugsPlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("effort", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return FindBugsPlugin.this.extension.getEffort();
            }
        });
        taskMapping.map("reportLevel", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return FindBugsPlugin.this.extension.getReportLevel();
            }
        });
        taskMapping.map("visitors", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getVisitors();
            }
        });
        taskMapping.map("omitVisitors", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getOmitVisitors();
            }
        });
        taskMapping.map("excludeFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getExcludeFilterConfig();
            }
        });
        taskMapping.map("includeFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getIncludeFilterConfig();
            }
        });
        taskMapping.map("excludeBugsFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getExcludeBugsFilterConfig();
            }
        });
        taskMapping.map("extraArgs", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getExtraArgs();
            }
        });
        taskMapping.map("jvmArgs", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getJvmArgs();
            }
        });
        taskMapping.map("showProgress", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return FindBugsPlugin.this.extension.isShowProgress();
            }
        });
    }

    private void configureReportsConventionMapping(FindBugs task, final String baseName) {
        task.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = FindBugsPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals("xml");
                    }
                });
                reportMapping.map("destination", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(FindBugsPlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(final SourceSet sourceSet, FindBugs task) {
        task.setDescription("Run FindBugs analysis for " + sourceSet.getName() + " classes");
        task.setSource((FileTree)sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classes", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getOutput().getClassesDirs();
            }
        });
        taskMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getCompileClasspath();
            }
        });
    }
}

