/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashValue;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final boolean missing;
    private final String status;
    private final List<String> statusScheme;
    @Nullable
    private final ModuleSource moduleSource;
    private final Map<String, DefaultConfigurationMetadata> configurations;
    @Nullable
    private final List<? extends ModuleComponentArtifactMetadata> artifactOverrides;
    private final List<? extends DependencyMetadata> dependencies;
    private final HashValue contentHash;

    protected AbstractModuleComponentResolveMetadata(MutableModuleComponentResolveMetadata metadata, Map<String, Configuration> configurationDefinitions, Iterable<Artifact> artifacts, ImmutableList<Exclude> excludes) {
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.dependencies = metadata.getDependencies();
        this.artifactOverrides = metadata.getArtifactOverrides();
        this.configurations = this.populateConfigurationsFromDescriptor(configurationDefinitions, (List<Exclude>)excludes);
        if (this.artifactOverrides != null) {
            this.populateArtifactsFromOverrides(this.artifactOverrides);
        } else {
            this.populateArtifacts(artifacts);
        }
        this.contentHash = metadata.getContentHash();
    }

    protected AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, @Nullable ModuleSource source) {
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = source;
        this.dependencies = metadata.getDependencies();
        this.artifactOverrides = metadata.artifactOverrides;
        this.configurations = metadata.configurations;
        this.contentHash = metadata.getContentHash();
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return EmptySchema.INSTANCE;
    }

    @Override
    public HashValue getContentHash() {
        return this.contentHash;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurations.keySet();
    }

    @Override
    public List<? extends ConfigurationMetadata> getConsumableConfigurationsHavingAttributes() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    private void populateArtifactsFromOverrides(List<? extends ModuleComponentArtifactMetadata> artifacts) {
        for (DefaultConfigurationMetadata configuration : this.configurations.values()) {
            configuration.addArtifacts(artifacts);
        }
    }

    private void populateArtifacts(Iterable<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            DefaultModuleComponentArtifactMetadata artifactMetadata = new DefaultModuleComponentArtifactMetadata(this.componentIdentifier, artifact.getArtifactName());
            for (String configuration : artifact.getConfigurations()) {
                this.configurations.get(configuration).addArtifact(artifactMetadata);
            }
        }
        HashSet<ConfigurationMetadata> visited = new HashSet<ConfigurationMetadata>();
        for (DefaultConfigurationMetadata configuration : this.configurations.values()) {
            configuration.collectInheritedArtifacts(visited);
        }
    }

    @Override
    @Nullable
    public List<? extends ModuleComponentArtifactMetadata> getArtifactOverrides() {
        return this.artifactOverrides;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public ConfigurationMetadata getConfiguration(String name) {
        return this.configurations.get(name);
    }

    private Map<String, DefaultConfigurationMetadata> populateConfigurationsFromDescriptor(Map<String, Configuration> configurationDefinitions, List<Exclude> excludes) {
        Set<String> configurationsNames = configurationDefinitions.keySet();
        HashMap<String, DefaultConfigurationMetadata> configurations = new HashMap<String, DefaultConfigurationMetadata>(configurationsNames.size());
        for (String configName : configurationsNames) {
            DefaultConfigurationMetadata configuration = this.populateConfigurationFromDescriptor(configName, configurationDefinitions, configurations, excludes);
            configuration.populateDependencies(this.dependencies);
        }
        return configurations;
    }

    private DefaultConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions, Map<String, DefaultConfigurationMetadata> configurations, List<Exclude> excludes) {
        DefaultConfigurationMetadata populated = configurations.get(name);
        if (populated != null) {
            return populated;
        }
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        List<String> extendsFrom = descriptorConfiguration.getExtendsFrom();
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        if (extendsFrom.isEmpty()) {
            populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, excludes);
            configurations.put(name, populated);
            return populated;
        }
        if (extendsFrom.size() == 1) {
            populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, Collections.singletonList(this.populateConfigurationFromDescriptor(extendsFrom.get(0), configurationDefinitions, configurations, excludes)), excludes);
            configurations.put(name, populated);
            return populated;
        }
        ArrayList<DefaultConfigurationMetadata> hierarchy = new ArrayList<DefaultConfigurationMetadata>(extendsFrom.size());
        for (String confName : extendsFrom) {
            hierarchy.add(this.populateConfigurationFromDescriptor(confName, configurationDefinitions, configurations, excludes));
        }
        populated = new DefaultConfigurationMetadata(this.componentIdentifier, name, transitive, visible, hierarchy, excludes);
        configurations.put(name, populated);
        return populated;
    }
}

