/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;

public class DefaultMutableMavenModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata
implements MutableMavenModuleResolveMetadata {
    private String packaging = "jar";
    private boolean relocated;
    private String snapshotTimestamp;
    private List<MutableVariantImpl> addedVariants;
    private ImmutableList<? extends ComponentVariant> variants;

    public static DefaultMutableMavenModuleResolveMetadata missing(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableMavenModuleResolveMetadata metadata = new DefaultMutableMavenModuleResolveMetadata(id, componentIdentifier);
        metadata.setMissing(true);
        return metadata;
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier) {
        this(id, componentIdentifier, (Collection<? extends DependencyMetadata>)ImmutableList.of());
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<? extends DependencyMetadata> dependencies) {
        super(id, componentIdentifier, (List<? extends DependencyMetadata>)ImmutableList.copyOf(dependencies));
    }

    DefaultMutableMavenModuleResolveMetadata(MavenModuleResolveMetadata metadata) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.variants = metadata.getVariants();
    }

    @Override
    public MavenModuleResolveMetadata asImmutable() {
        return new DefaultMavenModuleResolveMetadata(this);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public void setRelocated(boolean relocated) {
        this.relocated = relocated;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    public MutableComponentVariant addVariant(String variantName, ImmutableAttributes attributes) {
        MutableVariantImpl variant = new MutableVariantImpl(variantName, attributes);
        if (this.addedVariants == null) {
            this.addedVariants = new ArrayList<MutableVariantImpl>();
        }
        this.addedVariants.add(variant);
        return variant;
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        if (this.variants == null && this.addedVariants == null) {
            return ImmutableList.of();
        }
        if (this.variants != null && this.addedVariants == null) {
            return this.variants;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (this.variants != null) {
            builder.addAll(this.variants);
        }
        for (MutableVariantImpl variant : this.addedVariants) {
            builder.add((Object)new ImmutableVariantImpl(variant.name, variant.attributes, (ImmutableList<FileImpl>)ImmutableList.copyOf((Collection)variant.files)));
        }
        return builder.build();
    }

    private static class ImmutableVariantImpl
    implements ComponentVariant {
        private final String name;
        private final ImmutableAttributes attributes;
        private final ImmutableList<FileImpl> files;

        ImmutableVariantImpl(String name, ImmutableAttributes attributes, ImmutableList<FileImpl> files) {
            this.name = name;
            this.attributes = attributes;
            this.files = files;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.files;
        }
    }

    private static class FileImpl
    implements ComponentVariant.File {
        private final String name;
        private final String uri;

        FileImpl(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUri() {
            return this.uri;
        }
    }

    private static class MutableVariantImpl
    implements MutableComponentVariant {
        private final String name;
        private final ImmutableAttributes attributes;
        private final List<FileImpl> files = new ArrayList<FileImpl>();

        MutableVariantImpl(String name, ImmutableAttributes attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        @Override
        public void addFile(String name, String uri) {
            this.files.add(new FileImpl(name, uri));
        }
    }
}

