/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.swift.internal.DefaultSwiftCompileSpec;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

@Incubating
public class SwiftCompile
extends AbstractNativeCompileTask {
    private final Property<String> moduleName = this.getProject().getObjects().property(String.class);

    @Override
    protected NativeCompileSpec createCompileSpec() {
        DefaultSwiftCompileSpec spec = new DefaultSwiftCompileSpec();
        spec.setModuleName((String)this.moduleName.getOrNull());
        return spec;
    }

    @Override
    protected IncrementalCompilerBuilder getIncrementalCompilerBuilder() {
        return new IncrementalCompilerBuilder(){

            @Override
            public <T extends NativeCompileSpec> Compiler<T> createIncrementalCompiler(TaskInternal task, Compiler<T> compiler, NativeToolChain toolchain, HeaderDependenciesCollector headerDependenciesCollector) {
                return compiler;
            }
        };
    }

    @Optional
    @Input
    public String getModuleName() {
        return (String)this.moduleName.getOrNull();
    }

    public void setModuleName(String moduleName) {
        this.moduleName.set((Object)moduleName);
    }

    public void setModuleName(Provider<String> moduleName) {
        this.moduleName.set(moduleName);
    }

    @Override
    public void compile(IncrementalTaskInputs inputs) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.setDestinationDir((File)this.getObjectFileDir().getAsFile().get());
        cleaner.execute();
        if (this.getSource().isEmpty()) {
            this.setDidWork(cleaner.getDidWork());
            return;
        }
        super.compile(inputs);
    }
}

