/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.script.dependencies.ScriptContents;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.ScriptAnnotationsPreprocessingKt;
import org.jetbrains.kotlin.script.ScriptContentLoaderKt;
import org.jetbrains.kotlin.script.ScriptReportSink;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getAnnotationEntries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getEnvironment", "", "", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "getScriptContents", "Lorg/jetbrains/kotlin/script/ScriptContentLoader$BasicScriptContents;", "scriptDefinition", "loadAnnotations", "", "", "loadContentsAndResolveDependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "BasicScriptContents", "kotlin-compiler"})
public final class ScriptContentLoader {
    private final Project project;

    @NotNull
    public final BasicScriptContents getScriptContents(@NotNull KotlinScriptDefinition scriptDefinition2, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull(scriptDefinition2, "scriptDefinition");
        Intrinsics.checkParameterIsNotNull(file, "file");
        return new BasicScriptContents(file, (Function0<? extends Iterable<? extends Annotation>>)new Function0<List<? extends Annotation>>(this, scriptDefinition2, file){
            final /* synthetic */ ScriptContentLoader this$0;
            final /* synthetic */ KotlinScriptDefinition $scriptDefinition;
            final /* synthetic */ VirtualFile $file;

            @NotNull
            public final List<Annotation> invoke() {
                return ScriptContentLoader.access$loadAnnotations(this.this$0, this.$scriptDefinition, this.$file);
            }
            {
                this.this$0 = scriptContentLoader;
                this.$scriptDefinition = kotlinScriptDefinition;
                this.$file = virtualFile2;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<Annotation> loadAnnotations(KotlinScriptDefinition scriptDefinition2, VirtualFile file) {
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassLoader classLoader = JvmClassMappingKt.getJavaClass(scriptDefinition2.getTemplate()).getClassLoader();
        Iterable<KtAnnotationEntry> iterable = this.getAnnotationEntries(file, this.project);
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation2;
            Annotation annotation3;
            Object v1;
            Object object;
            KtAnnotationEntry psiAnn;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                psiAnn = (KtAnnotationEntry)element$iv$iv;
                object = scriptDefinition2.getAcceptedAnnotations();
                Iterable iterable2 = object;
                for (Object t : iterable2) {
                    KClass ann = (KClass)t;
                    String string = ScriptAnnotationsPreprocessingKt.getTypeName(psiAnn);
                    String it = string;
                    boolean bl = Intrinsics.areEqual(it, ann.getSimpleName()) || Intrinsics.areEqual(it, ann.getQualifiedName());
                    if (!bl) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            KClass kClass2 = v1;
            if (kClass2 != null) {
                Object it = object = kClass2;
                KClass<?> kClass3 = JvmClassMappingKt.getKotlinClass(classLoader.loadClass(it.getQualifiedName()));
                if (kClass3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<out kotlin.Annotation>");
                }
                annotation3 = ScriptAnnotationsPreprocessingKt.constructAnnotation(psiAnn, kClass3);
            } else {
                annotation3 = null;
            }
            if (annotation3 == null) continue;
            Annotation it$iv$iv = annotation2 = annotation3;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<KtAnnotationEntry> getAnnotationEntries(VirtualFile file, Project project) {
        Object object;
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file);
        if (psiFile == null) {
            throw (Throwable)new IllegalArgumentException("Unable to load PSI from " + file.getCanonicalPath());
        }
        PsiFile psiFile2 = psiFile;
        PsiFile psiFile3 = psiFile2;
        if (!(psiFile3 instanceof KtFile)) {
            psiFile3 = null;
        }
        if ((object = (KtFile)psiFile3) == null || (object = ((KtFile)object).getAnnotationEntries()) == null) {
            throw (Throwable)new IllegalArgumentException("Unable to extract kotlin annotations from " + file.getName() + " (" + file.getFileType() + ')');
        }
        return (Iterable)object;
    }

    @Nullable
    public final ScriptDependencies loadContentsAndResolveDependencies(@NotNull KotlinScriptDefinition scriptDef, @NotNull VirtualFile file) {
        DependenciesResolver.ResolveResult resolveResult;
        Intrinsics.checkParameterIsNotNull(scriptDef, "scriptDef");
        Intrinsics.checkParameterIsNotNull(file, "file");
        BasicScriptContents scriptContents = this.getScriptContents(scriptDef, file);
        Map<String, Object> environment2 = this.getEnvironment(scriptDef);
        try {
            resolveResult = scriptDef.getDependencyResolver().resolve(scriptContents, environment2);
        }
        catch (Throwable e) {
            resolveResult = ScriptContentLoaderKt.asResolveFailure(e, scriptDef);
        }
        DependenciesResolver.ResolveResult result2 = resolveResult;
        ScriptReportSink scriptReportSink = ServiceManager.getService(this.project, ScriptReportSink.class);
        if (scriptReportSink != null) {
            scriptReportSink.attachReports(file, result2.getReports());
        }
        ScriptDependencies scriptDependencies = result2.getDependencies();
        return scriptDependencies != null ? ScriptContentLoaderKt.adjustByDefinition(scriptDependencies, scriptDef) : null;
    }

    @NotNull
    public final Map<String, Object> getEnvironment(@NotNull KotlinScriptDefinition scriptDef) {
        Intrinsics.checkParameterIsNotNull(scriptDef, "scriptDef");
        KotlinScriptDefinition kotlinScriptDefinition = scriptDef;
        if (!(kotlinScriptDefinition instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
            kotlinScriptDefinition = null;
        }
        KotlinScriptDefinitionFromAnnotatedTemplate kotlinScriptDefinitionFromAnnotatedTemplate = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition;
        Map<String, Object> map2 = kotlinScriptDefinitionFromAnnotatedTemplate != null ? kotlinScriptDefinitionFromAnnotatedTemplate.getEnvironment() : null;
        Map<String, Object> map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    public ScriptContentLoader(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.project = project;
    }

    @NotNull
    public static final /* synthetic */ List access$loadAnnotations(ScriptContentLoader $this, @NotNull KotlinScriptDefinition scriptDefinition2, @NotNull VirtualFile file) {
        return $this.loadAnnotations(scriptDefinition2, file);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u001b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/script/ScriptContentLoader$BasicScriptContents;", "Lkotlin/script/dependencies/ScriptContents;", "virtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getAnnotations", "Lkotlin/Function0;", "", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function0;)V", "annotations", "()Ljava/lang/Iterable;", "annotations$delegate", "Lkotlin/Lazy;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "text", "", "getText", "()Ljava/lang/CharSequence;", "text$delegate", "kotlin-compiler"})
    public static final class BasicScriptContents
    implements ScriptContents {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final File file;
        @NotNull
        private final Lazy annotations$delegate;
        @Nullable
        private final Lazy text$delegate;

        static {
            $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(BasicScriptContents.class), "annotations", "getAnnotations()Ljava/lang/Iterable;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(BasicScriptContents.class), "text", "getText()Ljava/lang/CharSequence;"))};
        }

        @Override
        @NotNull
        public File getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public Iterable<Annotation> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            BasicScriptContents basicScriptContents = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (Iterable)lazy.getValue();
        }

        @Override
        @Nullable
        public CharSequence getText() {
            Lazy lazy = this.text$delegate;
            BasicScriptContents basicScriptContents = this;
            KProperty kProperty = $$delegatedProperties[1];
            return (CharSequence)lazy.getValue();
        }

        public BasicScriptContents(@NotNull VirtualFile virtualFile2, @NotNull Function0<? extends Iterable<? extends Annotation>> getAnnotations2) {
            Intrinsics.checkParameterIsNotNull(virtualFile2, "virtualFile");
            Intrinsics.checkParameterIsNotNull(getAnnotations2, "getAnnotations");
            this.file = new File(virtualFile2.getPath());
            this.annotations$delegate = LazyKt.lazy((Function0)new Function0<Iterable<? extends Annotation>>(getAnnotations2){
                final /* synthetic */ Function0 $getAnnotations;

                @NotNull
                public final Iterable<Annotation> invoke() {
                    return (Iterable)this.$getAnnotations.invoke();
                }
                {
                    this.$getAnnotations = function0;
                    super(0);
                }
            });
            this.text$delegate = LazyKt.lazy((Function0)new Function0<String>(virtualFile2){
                final /* synthetic */ VirtualFile $virtualFile;

                @NotNull
                public final String invoke() {
                    InputStream inputStream = this.$virtualFile.getInputStream();
                    Charset charset = this.$virtualFile.getCharset();
                    Intrinsics.checkExpressionValueIsNotNull(charset, "virtualFile.charset");
                    Charset charset2 = charset;
                    return TextStreamsKt.readText(new InputStreamReader(inputStream, charset2));
                }
                {
                    this.$virtualFile = virtualFile2;
                    super(0);
                }
            });
        }
    }
}

