/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.Date;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.plugins.JavaLanguagePlugin;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.routes.RoutesSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.ScalaJvmAssembly;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Each;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.Hidden;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PlayPlatformAwareComponentSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.DefaultPlayApplicationBinarySpec;
import org.gradle.play.internal.DefaultPlayPlatformAwareComponentSpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.PlayApplicationSpecInternal;
import org.gradle.play.internal.PlayPlatformAwareComponentSpecInternal;
import org.gradle.play.internal.PlayPlatformResolver;
import org.gradle.play.internal.platform.PlayPlatformInternal;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.play.plugins.PlayRoutesPlugin;
import org.gradle.play.plugins.PlayTwirlPlugin;
import org.gradle.play.tasks.PlayRun;
import org.gradle.util.VersionNumber;

@Incubating
public class PlayApplicationPlugin
implements Plugin<Project> {
    public static final int DEFAULT_HTTP_PORT = 9000;
    public static final String RUN_GROUP = "Run";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaLanguagePlugin.class);
        project.getPluginManager().apply(ScalaLanguagePlugin.class);
        project.getPluginManager().apply(PlayTwirlPlugin.class);
        project.getPluginManager().apply(PlayRoutesPlugin.class);
        project.getExtensions().create("playConfigurations", PlayPluginConfigurations.class, new Object[]{project.getConfigurations(), project.getDependencies()});
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        PlayPluginConfigurations configurations(ExtensionContainer extensions) {
            return (PlayPluginConfigurations)extensions.getByType(PlayPluginConfigurations.class);
        }

        @Model
        PlayToolChainInternal playToolChain(ServiceRegistry serviceRegistry) {
            return (PlayToolChainInternal)serviceRegistry.get(PlayToolChainInternal.class);
        }

        @Hidden
        @Model
        FileResolver fileResolver(ServiceRegistry serviceRegistry) {
            return (FileResolver)serviceRegistry.get(FileResolver.class);
        }

        @Hidden
        @Model
        ConfigurationContainer configurationContainer(ServiceRegistry serviceRegistry) {
            return (ConfigurationContainer)serviceRegistry.get(ConfigurationContainer.class);
        }

        @ComponentType
        void registerPlayPlatformAwareComponentSpecType(TypeBuilder<PlayPlatformAwareComponentSpec> builder) {
            builder.defaultImplementation(DefaultPlayPlatformAwareComponentSpec.class);
            builder.internalView(PlayPlatformAwareComponentSpecInternal.class);
        }

        @ComponentType
        void registerPlayApplicationSpecType(TypeBuilder<PlayApplicationSpec> builder) {
            builder.internalView(PlayApplicationSpecInternal.class);
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new PlayPlatformResolver());
        }

        @Mutate
        void createDefaultPlayApp(ModelMap<PlayApplicationSpec> builder) {
            builder.create("play");
        }

        @ComponentType
        void registerApplication(TypeBuilder<PlayApplicationBinarySpec> builder) {
            builder.defaultImplementation(DefaultPlayApplicationBinarySpec.class);
            builder.internalView(PlayApplicationBinarySpecInternal.class);
        }

        @Validate
        void failOnMultiplePlayComponents(ModelMap<PlayApplicationSpec> container) {
            if (container.size() >= 2) {
                throw new GradleException("Multiple components of type 'PlayApplicationSpec' are not supported.");
            }
        }

        @Validate
        void failOnMultipleTargetPlatforms(@Each PlayPlatformAwareComponentSpecInternal playApplication) {
            if (playApplication.getTargetPlatforms().size() > 1) {
                throw new GradleException("Multiple target platforms for 'PlayApplicationSpec' is not (yet) supported.");
            }
        }

        @Validate
        void failIfInjectedRouterIsUsedWithOldVersion(@Each PlayApplicationBinarySpec playApplicationBinary) {
            if (playApplicationBinary.getApplication().getInjectedRoutesGenerator()) {
                PlayPlatform playPlatform = playApplicationBinary.getTargetPlatform();
                VersionNumber minSupportedVersion = VersionNumber.parse((String)"2.4.0");
                VersionNumber playVersion = VersionNumber.parse((String)playPlatform.getPlayVersion());
                if (playVersion.compareTo(minSupportedVersion) < 0) {
                    throw new GradleException("Injected routers are only supported in Play 2.4 or newer.");
                }
            }
        }

        @ComponentBinaries
        void createBinaries(ModelMap<PlayApplicationBinarySpec> binaries, final PlayApplicationSpecInternal componentSpec, final PlatformResolvers platforms, final PlayToolChainInternal playToolChainInternal, final PlayPluginConfigurations configurations, final @Path(value="buildDir") File buildDir, final ProjectIdentifier projectIdentifier) {
            binaries.create("binary", (Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playBinary) {
                    PlayApplicationBinarySpecInternal playBinaryInternal = (PlayApplicationBinarySpecInternal)playBinary;
                    File binaryBuildDir = new File(buildDir, playBinaryInternal.getProjectScopedName());
                    PlayPlatform chosenPlatform = Rules.this.resolveTargetPlatform(componentSpec, platforms);
                    Rules.this.initialiseConfigurations(configurations, chosenPlatform);
                    playBinaryInternal.setTargetPlatform(chosenPlatform);
                    playBinaryInternal.setToolChain(playToolChainInternal);
                    File mainJar = new File(binaryBuildDir, "lib/" + projectIdentifier.getName() + ".jar");
                    File assetsJar = new File(binaryBuildDir, "lib/" + projectIdentifier.getName() + "-assets.jar");
                    playBinaryInternal.setJarFile(mainJar);
                    playBinaryInternal.setAssetsJarFile(assetsJar);
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", null, new Date(), mainJar, new Object[]{playBinaryInternal}));
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", "assets", new Date(), assetsJar, new Object[]{playBinaryInternal}));
                    ScalaJvmAssembly jvmAssembly = ((PlayApplicationBinarySpecInternal)playBinary).getAssembly();
                    jvmAssembly.getClassDirectories().add(new File(binaryBuildDir, "classes"));
                    jvmAssembly.getResourceDirectories().add(new File(binaryBuildDir, "resources"));
                    PublicAssets assets = playBinary.getAssets();
                    assets.addAssetDir(new File(projectIdentifier.getProjectDir(), "public"));
                    playBinaryInternal.setClasspath(configurations.getPlay().getAllArtifacts());
                }
            });
        }

        @Mutate
        void generatedSourcesAreInputs(@Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> binaries, ServiceRegistry serviceRegistry) {
            binaries.afterEach((Action)new Action<PlayApplicationBinarySpecInternal>(){

                public void execute(PlayApplicationBinarySpecInternal playApplicationBinarySpec) {
                    for (ScalaLanguageSourceSet scalaLanguageSourceSet : playApplicationBinarySpec.getGeneratedScala().values()) {
                        playApplicationBinarySpec.getInputs().add((Object)scalaLanguageSourceSet);
                    }
                    for (JavaScriptSourceSet javaScriptSourceSet : playApplicationBinarySpec.getGeneratedJavaScript().values()) {
                        playApplicationBinarySpec.getInputs().add((Object)javaScriptSourceSet);
                    }
                }
            });
        }

        private PlayPlatform resolveTargetPlatform(PlayApplicationSpecInternal componentSpec, PlatformResolvers platforms) {
            PlatformRequirement targetPlatform = this.getTargetPlatform(componentSpec);
            return (PlayPlatform)platforms.resolve(PlayPlatform.class, targetPlatform);
        }

        private PlatformRequirement getTargetPlatform(PlayApplicationSpecInternal playApplicationSpec) {
            if (playApplicationSpec.getTargetPlatforms().isEmpty()) {
                String defaultPlayPlatform = "play-2.3.10";
                return DefaultPlatformRequirement.create((String)defaultPlayPlatform);
            }
            return (PlatformRequirement)playApplicationSpec.getTargetPlatforms().get(0);
        }

        private void initialiseConfigurations(PlayPluginConfigurations configurations, PlayPlatform playPlatform) {
            configurations.getPlayPlatform().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play"));
            configurations.getPlayTest().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-test"));
            configurations.getPlayRun().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-docs"));
        }

        @BinaryTasks
        void createScalaCompileTask(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary, @Path(value="buildDir") File buildDir) {
            tasks.withType(PlatformScalaCompile.class).afterEach((Action)new Action<PlatformScalaCompile>(){

                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setClasspath(((PlayApplicationBinarySpecInternal)binary).getClasspath());
                }
            });
        }

        @BinaryTasks
        void createJarTasks(ModelMap<Task> tasks, final PlayApplicationBinarySpecInternal binary) {
            String jarTaskName = binary.getTasks().taskName("create", "Jar");
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles the application jar for the " + binary.getDisplayName() + ".");
                    jar.setDestinationDir(binary.getJarFile().getParentFile());
                    jar.setArchiveName(binary.getJarFile().getName());
                    jar.from(new Object[]{binary.getAssembly().getClassDirectories()});
                    jar.from(new Object[]{binary.getAssembly().getResourceDirectories()});
                    jar.dependsOn(new Object[]{binary.getAssembly()});
                }
            });
            String assetsJarTaskName = binary.getTasks().taskName("create", "assetsJar");
            tasks.create(assetsJarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles the assets jar for the " + binary.getDisplayName() + ".");
                    jar.setDestinationDir(binary.getAssetsJarFile().getParentFile());
                    jar.setArchiveName(binary.getAssetsJarFile().getName());
                    jar.setClassifier("assets");
                    CopySpecInternal newSpec = jar.getRootSpec().addChild();
                    newSpec.from(new Object[]{binary.getAssets().getAssetDirs()});
                    newSpec.into((Object)"public");
                    jar.dependsOn(new Object[]{binary.getAssets()});
                }
            });
        }

        @Mutate
        void createPlayRunTask(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> playBinaries, ServiceRegistry serviceRegistry, final PlayPluginConfigurations configurations, ProjectIdentifier projectIdentifier, final PlayToolChainInternal playToolChain) {
            for (final PlayApplicationBinarySpecInternal binary : playBinaries) {
                String runTaskName = binary.getTasks().taskName("run");
                tasks.create(runTaskName, PlayRun.class, (Action)new Action<PlayRun>(){

                    public void execute(PlayRun playRun) {
                        playRun.setDescription("Runs the Play application for local development.");
                        playRun.setGroup(PlayApplicationPlugin.RUN_GROUP);
                        playRun.setHttpPort(9000);
                        playRun.setPlayToolProvider(playToolChain.select(binary.getTargetPlatform()));
                        playRun.setApplicationJar(binary.getJarFile());
                        playRun.setAssetsJar(binary.getAssetsJarFile());
                        playRun.setAssetsDirs(binary.getAssets().getAssetDirs());
                        playRun.setRuntimeClasspath(configurations.getPlayRun().getNonChangingArtifacts());
                        playRun.setChangingClasspath(configurations.getPlayRun().getChangingArtifacts());
                        playRun.dependsOn(new Object[]{binary.getBuildTask()});
                    }
                });
            }
        }

        @Defaults
        void createJvmSourceSets(@Each PlayApplicationSpec playComponent) {
            playComponent.getSources().create("scala", ScalaLanguageSourceSet.class, (Action)new Action<ScalaLanguageSourceSet>(){

                public void execute(ScalaLanguageSourceSet scalaSources) {
                    scalaSources.getSource().srcDir((Object)"app");
                    scalaSources.getSource().include(new String[]{"**/*.scala"});
                }
            });
            playComponent.getSources().create("java", JavaSourceSet.class, (Action)new Action<JavaSourceSet>(){

                public void execute(JavaSourceSet javaSources) {
                    javaSources.getSource().srcDir((Object)"app");
                    javaSources.getSource().include(new String[]{"**/*.java"});
                }
            });
            playComponent.getSources().create("resources", JvmResourceSet.class, (Action)new Action<JvmResourceSet>(){

                public void execute(JvmResourceSet appResources) {
                    appResources.getSource().srcDirs(new Object[]{"conf"});
                }
            });
        }

        @Defaults
        void createTwirlSourceSets(@Each PlayApplicationSpec playComponent) {
            playComponent.getSources().create("twirlTemplates", TwirlSourceSet.class, (Action)new Action<TwirlSourceSet>(){

                public void execute(TwirlSourceSet twirlSourceSet) {
                    twirlSourceSet.getSource().srcDir((Object)"app");
                    twirlSourceSet.getSource().include(new String[]{"**/*.scala.*"});
                }
            });
        }

        @Defaults
        void createRoutesSourceSets(@Each PlayApplicationSpec playComponent) {
            playComponent.getSources().create("routes", RoutesSourceSet.class, (Action)new Action<RoutesSourceSet>(){

                public void execute(RoutesSourceSet routesSourceSet) {
                    routesSourceSet.getSource().srcDir((Object)"conf");
                    routesSourceSet.getSource().include(new String[]{"routes"});
                    routesSourceSet.getSource().include(new String[]{"*.routes"});
                }
            });
        }
    }
}

