/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.play.internal.run.DefaultPlayRunSpec;
import org.gradle.play.internal.run.PlayApplicationDeploymentHandle;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class PlayRun
extends ConventionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayRun.class);
    private int httpPort;
    @InputFile
    private File applicationJar;
    @InputFile
    private File assetsJar;
    @InputFiles
    private Set<File> assetsDirs;
    @Classpath
    private FileCollection runtimeClasspath;
    @Classpath
    private FileCollection changingClasspath;
    private BaseForkOptions forkOptions;
    private PlayToolProvider playToolProvider;

    @Nested
    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }

    @TaskAction
    public void run() {
        String deploymentId = this.getPath();
        DeploymentRegistry deploymentRegistry = this.getDeploymentRegistry();
        PlayApplicationDeploymentHandle deploymentHandle = (PlayApplicationDeploymentHandle)deploymentRegistry.get(deploymentId, PlayApplicationDeploymentHandle.class);
        if (deploymentHandle == null) {
            DefaultPlayRunSpec spec = new DefaultPlayRunSpec((Iterable<File>)this.runtimeClasspath, (Iterable<File>)this.changingClasspath, this.applicationJar, this.assetsJar, this.assetsDirs, this.getProject().getProjectDir(), this.getForkOptions(), this.getHttpPort());
            PlayApplicationRunner playApplicationRunner = (PlayApplicationRunner)this.playToolProvider.get(PlayApplicationRunner.class);
            deploymentHandle = (PlayApplicationDeploymentHandle)deploymentRegistry.start(deploymentId, DeploymentRegistry.ChangeBehavior.BLOCK, PlayApplicationDeploymentHandle.class, new Object[]{spec, playApplicationRunner});
            InetSocketAddress playAppAddress = deploymentHandle.getPlayAppAddress();
            String playUrl = "http://localhost:" + playAppAddress.getPort() + "/";
            LOGGER.warn("Running Play App ({}) at {}", (Object)this.getPath(), (Object)playUrl);
        }
    }

    @Internal
    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public File getApplicationJar() {
        return this.applicationJar;
    }

    public void setApplicationJar(File applicationJar) {
        this.applicationJar = applicationJar;
    }

    public File getAssetsJar() {
        return this.assetsJar;
    }

    public void setAssetsJar(File assetsJar) {
        this.assetsJar = assetsJar;
    }

    public Set<File> getAssetsDirs() {
        return this.assetsDirs;
    }

    public void setAssetsDirs(Set<File> assetsDirs) {
        this.assetsDirs = assetsDirs;
    }

    public void setRuntimeClasspath(FileCollection runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public void setChangingClasspath(FileCollection changingClasspath) {
        this.changingClasspath = changingClasspath;
    }

    public void setPlayToolProvider(PlayToolProvider playToolProvider) {
        this.playToolProvider = playToolProvider;
    }

    @Inject
    public DeploymentRegistry getDeploymentRegistry() {
        throw new UnsupportedOperationException();
    }
}

