/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class LineSepWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        LineSepWidget lineSepWidget = new LineSepWidget(view);
        return lineSepWidget;
    }

    private static class LineSepWidget
    implements Widget {
        private final JLabel lineSep = new ToolTipLabel();
        private final View view;

        LineSepWidget(final View view) {
            this.lineSep.setHorizontalAlignment(0);
            this.lineSep.setToolTipText(jEdit.getProperty("view.status.linesep-tooltip"));
            this.view = view;
            this.lineSep.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    view.getBuffer().toggleLineSeparator(view);
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.lineSep;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            String string = buffer.getStringProperty("lineSeparator");
            if ("\n".equals(string)) {
                this.lineSep.setText("U");
            } else if ("\r\n".equals(string)) {
                this.lineSep.setText("W");
            } else if ("\r".equals(string)) {
                this.lineSep.setText("M");
            }
        }

        @Override
        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fontMetrics = this.lineSep.getFontMetrics(font);
            Dimension dimension = new Dimension(Math.max(Math.max(fontMetrics.charWidth('U'), fontMetrics.charWidth('W')), fontMetrics.charWidth('M')) + 1, fontMetrics.getHeight());
            this.lineSep.setPreferredSize(dimension);
            this.lineSep.setMaximumSize(dimension);
        }
    }
}

