/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public class PageBreakExtension
extends TextAreaExtension
implements EBComponent {
    private JEditTextArea textArea;
    private boolean showPageBreak;
    private Color pageBreakColor;
    private HashMap<Integer, Range> pages = null;

    public PageBreakExtension(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        jEditTextArea.getPainter().addExtension(-20, this);
        this.showPageBreak = jEdit.getBooleanProperty("view.pageBreaks", false);
        this.pageBreakColor = jEdit.getColorProperty("view.pageBreaksColor");
        EditBus.addToBus(this);
    }

    private void loadPageRanges() {
        if (this.showPageBreak) {
            View view = this.textArea.getView();
            Buffer buffer = (Buffer)this.textArea.getBuffer();
            this.pages = BufferPrinter1_7.getPageRanges(view, buffer, null);
        } else {
            this.pages = null;
        }
    }

    @Override
    public void handleMessage(EBMessage eBMessage) {
        BufferUpdate bufferUpdate;
        if (eBMessage instanceof PropertiesChanged) {
            this.showPageBreak = jEdit.getBooleanProperty("view.pageBreaks");
            this.pageBreakColor = jEdit.getColorProperty("view.pageBreaksColor");
            this.loadPageRanges();
        } else if (eBMessage instanceof EditPaneUpdate) {
            EditPaneUpdate editPaneUpdate = (EditPaneUpdate)eBMessage;
            if (EditPaneUpdate.BUFFER_CHANGED.equals(editPaneUpdate.getWhat()) && editPaneUpdate.getEditPane().getBuffer().isLoaded()) {
                this.loadPageRanges();
            }
        } else if (eBMessage instanceof BufferUpdate && (BufferUpdate.SAVED.equals((bufferUpdate = (BufferUpdate)eBMessage).getWhat()) || BufferUpdate.LOADED.equals(bufferUpdate.getWhat()))) {
            this.loadPageRanges();
        }
    }

    public Color getPageBreakColor() {
        return this.pageBreakColor;
    }

    public void setPageBreakColor(Color color) {
        this.pageBreakColor = color;
    }

    public boolean isPageBreakEnabled() {
        return this.showPageBreak;
    }

    public void setPageBreakEnabled(boolean bl) {
        this.showPageBreak = bl;
    }

    @Override
    public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        if (this.showPageBreak) {
            if (this.pages == null || this.pages.isEmpty()) {
                this.loadPageRanges();
                if (this.pages == null || this.pages.isEmpty()) {
                    return;
                }
            }
            graphics2D.setColor(this.pageBreakColor);
            for (int i = 1; i < this.pages.size(); ++i) {
                Range range = this.pages.get(i);
                if (range.getEnd() != n2 || this.textArea.getLineEndOffset(n2) != n4) continue;
                graphics2D.drawLine(0, n5 += graphics2D.getFontMetrics().getHeight(), this.textArea.getPainter().getWidth(), n5);
            }
        }
    }
}

