/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;

class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static boolean isAbstract(@NotNull JavaModifierListOwnerImpl owner) {
        return owner.getPsi().hasModifierProperty("abstract");
    }

    public static boolean isStatic(@NotNull JavaModifierListOwnerImpl owner) {
        return owner.getPsi().hasModifierProperty("static");
    }

    public static boolean isFinal(@NotNull JavaModifierListOwnerImpl owner) {
        return owner.getPsi().hasModifierProperty("final");
    }

    @NotNull
    public static Visibility getVisibility(@NotNull JavaModifierListOwnerImpl owner) {
        PsiModifierListOwner psiOwner = owner.getPsi();
        if (psiOwner.hasModifierProperty("public")) {
            return Visibilities.PUBLIC;
        }
        if (psiOwner.hasModifierProperty("private")) {
            return Visibilities.PRIVATE;
        }
        if (psiOwner.hasModifierProperty("protected")) {
            return owner.isStatic() ? JavaVisibilities.PROTECTED_STATIC_VISIBILITY : JavaVisibilities.PROTECTED_AND_PACKAGE;
        }
        return JavaVisibilities.PACKAGE_VISIBILITY;
    }

    @NotNull
    public static Collection<JavaAnnotation> getAnnotations(@NotNull JavaAnnotationOwnerImpl owner) {
        PsiAnnotationOwner annotationOwnerPsi = owner.getAnnotationOwnerPsi();
        if (annotationOwnerPsi != null) {
            return JavaElementCollectionFromPsiArrayUtil.annotations(annotationOwnerPsi.getAnnotations());
        }
        return Collections.emptyList();
    }

    @Nullable
    public static JavaAnnotation findAnnotation(@NotNull JavaAnnotationOwnerImpl owner, @NotNull FqName fqName2) {
        PsiAnnotationOwner annotationOwnerPsi = owner.getAnnotationOwnerPsi();
        if (annotationOwnerPsi != null) {
            PsiAnnotation psiAnnotation = annotationOwnerPsi.findAnnotation(fqName2.asString());
            return psiAnnotation == null ? null : new JavaAnnotationImpl(psiAnnotation);
        }
        return null;
    }
}

