/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00020\u0001B'\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ=\u0010\r\u001a\n \u000f*\u0004\u0018\u0001H\u000eH\u000e\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "", "value", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "elementType", "getElementType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "core"})
public final class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    @NotNull
    private final KotlinType type;
    private final KotlinBuiltIns builtIns;

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitArrayValue(this, data);
    }

    @NotNull
    public final KotlinType getElementType() {
        KotlinType kotlinType = this.builtIns.getArrayElementType(this.getType());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.getArrayElementType(type)");
        return kotlinType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(other.getClass(), this.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((List)this.getValue(), (List)((ArrayValue)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    @NotNull
    public KotlinType getType() {
        return this.type;
    }

    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value, @NotNull KotlinType type2, @NotNull KotlinBuiltIns builtIns) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(value);
        this.type = type2;
        this.builtIns = builtIns;
        boolean bl2 = bl = KotlinBuiltIns.isArray(this.getType()) || KotlinBuiltIns.isPrimitiveArray(this.getType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Type should be an array, but was " + this.getType() + ": " + value;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

