'use strict';

module.exports = help;

var fs = require('then-fs');
var path = require('path');

function help(args, config) {
  var root = args.root;
  return getHelpItem(args, config).then(function (item) {
    return fs.readFile(path.join(root, item), 'utf8');
  });
}

function getHelpItem(args, config) {
  return new Promise(function (resolve, reject) {
    if (config.help) {
      if (args.help === true) {
        return resolve(config.help._ || config.help);
      }

      if (config.help[args.help]) {
        return resolve(config.help[args.help]);
      }

      return reject(new Error('"' + args.help + '" help can\'t be found'));
    }

    var error = new Error('No help configured');
    error.code = 'NO_HELP_CONFIGURED';
    reject(error);
  });
}