/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntax;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class DLSyntaxObjectRenderer
extends OWLObjectVisitorAdapter
implements OWLObjectRenderer,
OWLObjectVisitor {
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();
    private final IRIShortFormProvider iriShortFormProvider = new SimpleIRIShortFormProvider();
    private StringBuilder buffer = new StringBuilder();
    private OWLObject focusedObject;

    public void setFocusedObject(@Nonnull OWLObject focusedObject) {
        this.focusedObject = OWLAPIPreconditions.checkNotNull(focusedObject, "focusedObject cannot be null");
    }

    public boolean isFocusedObject(OWLObject obj) {
        if (this.focusedObject == null) {
            return false;
        }
        return this.focusedObject.equals(obj);
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
    }

    @Override
    @Nonnull
    public String render(OWLObject object) {
        this.buffer = new StringBuilder();
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null").accept(this);
        return this.buffer.toString();
    }

    @Override
    public void visit(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        for (OWLAxiom oWLAxiom : CollectionFactory.sortOptionally(ontology.getLogicalAxioms())) {
            oWLAxiom.accept(this);
            this.write("\n");
        }
    }

    protected void write(@Nonnull String s) {
        this.buffer.append(OWLAPIPreconditions.checkNotNull(s, "s cannot be null"));
    }

    @Nonnull
    protected String renderEntity(@Nonnull OWLEntity entity) {
        return this.shortFormProvider.getShortForm(OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null"));
    }

    protected void writeEntity(@Nonnull OWLEntity entity) {
        this.write(this.renderEntity(OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null")));
    }

    protected void write(@Nonnull DLSyntax keyword) {
        this.write(OWLAPIPreconditions.checkNotNull(keyword, "keyword cannot be null").toString());
    }

    protected void write(int i) {
        this.write(Integer.toString(i));
    }

    protected void writeNested(@Nonnull OWLObject object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        if (DLSyntaxObjectRenderer.isBracketedIfNested(object)) {
            this.write("(");
        }
        object.accept(this);
        if (DLSyntaxObjectRenderer.isBracketedIfNested(object)) {
            this.write(")");
        }
    }

    protected static boolean isBracketedIfNested(@Nonnull OWLObject object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        return !(object instanceof OWLEntity);
    }

    private void writeObject(@Nonnull OWLObject object, boolean nest) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        if (nest) {
            this.writeNested(object);
        } else {
            object.accept(this);
        }
    }

    protected void write(@Nonnull Collection<? extends OWLObject> objects, @Nonnull DLSyntax delim, boolean nest) {
        OWLAPIPreconditions.checkNotNull(objects, "objects cannot be null");
        OWLAPIPreconditions.checkNotNull(delim, "delim cannot be null");
        if (objects.size() == 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject o1 = it.next();
            OWLObject o2 = it.next();
            assert (o1 != null);
            assert (o2 != null);
            if (this.isFocusedObject(o1) || !this.isFocusedObject(o2)) {
                this.writeObject(o1, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o2, nest);
            } else {
                this.writeObject(o2, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o1, nest);
            }
        } else {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                OWLObject o = it.next();
                assert (o != null);
                this.writeObject(o, nest);
                if (!it.hasNext()) continue;
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
            }
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null").getSubClass().accept(this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
    }

    private void writePropertyAssertion(@Nonnull OWLPropertyAssertionAxiom<?, ?> ax) {
        OWLAPIPreconditions.checkNotNull(ax, "ax cannot be null");
        if (ax instanceof OWLNegativeObjectPropertyAssertionAxiom || ax instanceof OWLNegativeDataPropertyAssertionAxiom) {
            this.write(DLSyntax.NOT);
        }
        ax.getProperty().accept(this);
        this.write("(");
        ax.getSubject().accept(this);
        this.write(", ");
        ax.getObject().accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        ArrayList<OWLClassExpression> descs = new ArrayList<OWLClassExpression>(axiom.getClassExpressions());
        for (int i = 0; i < descs.size() - 1; ++i) {
            for (int j = i + 1; j < descs.size(); ++j) {
                ((OWLClassExpression)descs.get(i)).accept(this);
                this.writeSpace();
                this.write(DLSyntax.DISJOINT_WITH);
                this.writeSpace();
                ((OWLClassExpression)descs.get(j)).accept(this);
                if (j >= descs.size() - 1) continue;
                this.write(", ");
            }
            if (i >= descs.size() - 2) continue;
            this.write(", ");
        }
    }

    private void writeDomainAxiom(@Nonnull OWLPropertyDomainAxiom<?> axiom) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        axiom.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.writeNested(axiom.getDomain());
    }

    private void writeRestrictionSeparator() {
        this.write(".");
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeDomainAxiom(axiom);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeDomainAxiom(axiom);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.NOT_EQUAL, false);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    private void writeRangeAxiom(@Nonnull OWLPropertyRangeAxiom<?, ?> axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.FORALL);
        this.writeSpace();
        axiom.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)axiom.getRange());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeRangeAxiom(axiom);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion(axiom);
    }

    private void writeFunctionalProperty(@Nonnull OWLPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull(property, "property cannot be null");
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        property.accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writeFunctionalProperty((OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        this.write(DLSyntax.EQUAL);
        this.write(axiom.getClassExpressions(), DLSyntax.OR, false);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(DLSyntax.INVERSE);
    }

    private void writeSpace() {
        this.write(" ");
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeRangeAxiom(axiom);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writeFunctionalProperty((OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            this.write("(");
        }
        axiom.getClassExpression().accept(this);
        if (axiom.getClassExpression().isAnonymous()) {
            this.write(")");
        }
        this.write("(");
        axiom.getIndividual().accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), DLSyntax.EQUIVALENT_TO, false);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion(axiom);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.IN);
        this.writeSpace();
        this.write("R");
        this.write("\u207a");
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.NOT);
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(DLSyntax.DISJOINT_WITH);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(DLSyntax.SUBCLASS);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.EQUAL, false);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.write(axiom.getPropertyChain(), DLSyntax.COMP, false);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression second;
        OWLObjectPropertyExpression first;
        OWLObjectPropertyExpression o1 = axiom.getFirstProperty();
        OWLObjectPropertyExpression o2 = axiom.getSecondProperty();
        if (this.isFocusedObject(o1) || !this.isFocusedObject(o2)) {
            first = o1;
            second = o2;
        } else {
            first = o2;
            second = o1;
        }
        first.accept(this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        second.accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(SWRLRule rule) {
        this.write(rule.getHead(), DLSyntax.WEDGE, false);
        this.writeSpace();
        this.write(DLSyntax.IMPLIES);
        this.writeSpace();
        this.write(rule.getBody(), DLSyntax.WEDGE, false);
    }

    @Override
    public void visit(OWLClass ce) {
        if (ce.isOWLThing()) {
            this.write(DLSyntax.TOP);
        } else if (ce.isOWLNothing()) {
            this.write(DLSyntax.BOTTOM);
        } else {
            this.writeEntity(ce);
        }
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.write(ce.getOperands(), DLSyntax.AND, true);
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.write(ce.getOperands(), DLSyntax.OR, true);
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.write(DLSyntax.NOT);
        this.writeNested(ce.getOperand());
    }

    private void writeCardinalityRestriction(OWLDataCardinalityRestriction restriction, @Nonnull DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        this.write(restriction.getCardinality());
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeCardinalityRestriction(OWLObjectCardinalityRestriction restriction, @Nonnull DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        this.write(restriction.getCardinality());
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeQuantifiedRestriction(OWLQuantifiedDataRestriction restriction, @Nonnull DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeQuantifiedRestriction(OWLQuantifiedObjectRestriction restriction, @Nonnull DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        restriction.getProperty().accept(this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeQuantifiedRestriction(ce, DLSyntax.EXISTS);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeQuantifiedRestriction(ce, DLSyntax.FORALL);
    }

    private <V extends OWLObject> void writeValueRestriction(OWLHasValueRestriction<V> restriction, OWLPropertyExpression p) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        p.accept(this);
        this.writeRestrictionSeparator();
        this.write("{");
        restriction.getFiller().accept(this);
        this.write("}");
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.writeValueRestriction(ce, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.MIN);
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.EQUAL);
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ce.getProperty().accept(this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        Iterator<OWLIndividual> it = ce.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("{");
            it.next().accept(this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(" ");
            this.write(DLSyntax.OR);
            this.write(" ");
        }
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeQuantifiedRestriction(ce, DLSyntax.EXISTS);
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeQuantifiedRestriction(ce, DLSyntax.FORALL);
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.writeValueRestriction(ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.MIN);
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.EQUAL);
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writeCardinalityRestriction(ce, DLSyntax.MAX);
    }

    @Override
    public void visit(OWLDatatype node) {
        this.write(this.shortFormProvider.getShortForm(node));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(DLSyntax.NOT);
        node.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Iterator<OWLLiteral> it = node.getValues().iterator();
        while (it.hasNext()) {
            this.write("{");
            it.next().accept(this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(DLSyntax.OR);
        }
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
    }

    @Override
    public void visit(OWLLiteral node) {
        this.write(node.getLiteral());
    }

    @Override
    public void visit(OWLFacetRestriction node) {
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.writeEntity(property);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        property.getInverse().accept(this);
        this.write(DLSyntax.INVERSE);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.writeEntity(property);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.writeEntity(individual);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.write(node.getPredicate().toString());
        this.write("(");
        this.write(node.getArguments(), DLSyntax.COMMA, true);
        this.write(")");
    }

    @Override
    public void visit(SWRLVariable node) {
        this.write("?");
        this.write(this.iriShortFormProvider.getShortForm(node.getIRI()));
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.write("sameAs(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write("differentFrom(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.write(node.getOperands(), DLSyntax.AND, true);
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.write(node.getOperands(), DLSyntax.OR, true);
    }
}

