/*
 * Decompiled with CFR 0.152.
 */
package at.jta;

import at.jta.NotSupportedOSException;
import at.jta.RegistryErrorException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class Regor {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private Method openKey = null;
    private Method closeKey = null;
    private Method delKey = null;
    private Method createKey = null;
    private Method flushKey = null;
    private Method queryValue = null;
    private Method setValue = null;
    private Method delValue = null;
    private Method queryInfoKey = null;
    private Method enumKey = null;
    private Method enumValue = null;

    public Regor() throws RegistryErrorException {
        this.checkOS();
        this.initMethods();
    }

    private void checkOS() {
        String str = System.getProperty("os.name");
        if (str == null || str.toLowerCase().indexOf("windows") == -1) {
            throw new NotSupportedOSException("Operating system: " + str + " is not supported!");
        }
    }

    public byte[] enumValueName(int key, int valueNameIndex, int maxValueNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumValue.invoke(null, new Integer(key), new Integer(valueNameIndex), new Integer(maxValueNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public List listValueNames(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x != info[2]; ++x) {
                    String tmp = Regor.parseValue(this.enumValueName(handle, x, info[4] + 1));
                    if (tmp == null) continue;
                    ret.add(tmp);
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public List listValueNames(int key) throws RegistryErrorException {
        return this.listValueNames(key, null);
    }

    public byte[] enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws RegistryErrorException {
        try {
            return (byte[])this.enumKey.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public List listKeys(int key, String subkey) throws RegistryErrorException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x != info[0]; ++x) {
                    String tmp = Regor.parseValue(this.enumKeys(handle, x, info[3] + 1));
                    if (tmp == null) continue;
                    ret.add(tmp);
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (RegistryErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public List listKeys(int key) throws RegistryErrorException {
        return this.listKeys(key, null);
    }

    public int[] getChildInformation(int key) throws RegistryErrorException {
        try {
            return (int[])this.queryInfoKey.invoke(null, new Integer(key));
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int delValue(int key, String valueName) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.delValue.invoke(null, new Integer(key), this.getString(valueName));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int setValue(int key, String valueName, String value) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.setValue.invoke(null, new Integer(key), this.getString(valueName), this.getString(value));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public byte[] readValue(int key, String valueName) throws RegistryErrorException {
        try {
            byte[] ret = (byte[])this.queryValue.invoke(null, new Integer(key), this.getString(valueName));
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int flushKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.flushKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int delKey(int key, String subkey) throws RegistryErrorException {
        if (subkey == null || subkey.length() == 0) {
            throw new RegistryErrorException("subkey cannot be null");
        }
        try {
            Integer ret = (Integer)this.delKey.invoke(null, new Integer(key), this.getString(subkey));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int createKey(int key, String subkey) throws RegistryErrorException {
        try {
            int[] result = (int[])this.createKey.invoke(null, new Integer(key), this.getString(subkey));
            if (result[1] == 0) {
                return result[0];
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int closeKey(int key) throws RegistryErrorException {
        try {
            Integer ret = (Integer)this.closeKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public int openKey(int key, String subkey, int security_mask) throws RegistryErrorException {
        try {
            int[] result = (int[])this.openKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
            if (result == null || result[1] != 0) {
                return -1;
            }
            return result[0];
        }
        catch (InvocationTargetException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new RegistryErrorException(ex1.getMessage());
        }
    }

    public int openKey(int key, String subkey) throws RegistryErrorException {
        return this.openKey(key, subkey, 983103);
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = str + "\u0000";
        return str.getBytes();
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private void initMethods() throws RegistryErrorException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method[] ms = clazz.getDeclaredMethods();
            if (ms == null) {
                throw new RegistryErrorException("Cannot access java.util.prefs.WindowsPreferences class!");
            }
            for (int x = 0; x != ms.length; ++x) {
                if (ms[x] == null) continue;
                if (ms[x].getName().equals("WindowsRegOpenKey")) {
                    this.openKey = ms[x];
                    ((AccessibleObject)this.openKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegCloseKey")) {
                    this.closeKey = ms[x];
                    ((AccessibleObject)this.closeKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegCreateKeyEx")) {
                    this.createKey = ms[x];
                    ((AccessibleObject)this.createKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegDeleteKey")) {
                    this.delKey = ms[x];
                    ((AccessibleObject)this.delKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegFlushKey")) {
                    this.flushKey = ms[x];
                    ((AccessibleObject)this.flushKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegQueryValueEx")) {
                    this.queryValue = ms[x];
                    ((AccessibleObject)this.queryValue).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegSetValueEx")) {
                    this.setValue = ms[x];
                    ((AccessibleObject)this.setValue).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegDeleteValue")) {
                    this.delValue = ms[x];
                    ((AccessibleObject)this.delValue).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegQueryInfoKey")) {
                    this.queryInfoKey = ms[x];
                    ((AccessibleObject)this.queryInfoKey).setAccessible(true);
                    continue;
                }
                if (ms[x].getName().equals("WindowsRegEnumKeyEx")) {
                    this.enumKey = ms[x];
                    ((AccessibleObject)this.enumKey).setAccessible(true);
                    continue;
                }
                if (!ms[x].getName().equals("WindowsRegEnumValue")) continue;
                this.enumValue = ms[x];
                ((AccessibleObject)this.enumValue).setAccessible(true);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RegistryErrorException(ex.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        int x;
        Regor regor = new Regor();
        int key = regor.openKey(-2147483646, "Software\\Microsoft");
        int key2 = -1;
        List l = regor.listKeys(key);
        System.out.println("SOME KEYS....");
        for (x = 0; l != null && x != l.size(); ++x) {
            System.out.println(x + " == " + l.get(x));
        }
        if (l.size() > 0) {
            key2 = regor.openKey(key, (String)l.get(0));
        }
        l = regor.listValueNames(key2);
        System.out.println("SOME VALUENAMES.....");
        for (x = 0; l != null && x != l.size(); ++x) {
            System.out.println(x + " == " + l.get(x));
        }
        System.out.println("SOME STRING VALUES....");
        for (x = 0; l != null && x != l.size(); ++x) {
            byte[] buf = regor.readValue(key2, (String)l.get(x));
            System.out.println(x + ": " + l.get(x) + " == " + Regor.parseValue(buf));
        }
        System.out.println("default entry == " + Regor.parseValue(regor.readValue(key, null)));
        l = regor.listKeys(-2147483646);
        System.out.println("KEYS FROM LOCAL_MACHINE....");
        for (x = 0; l != null && x != l.size(); ++x) {
            System.out.println(x + " == " + l.get(x));
        }
        regor.closeKey(key2);
        regor.closeKey(key);
    }
}

