/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantJSONQuery
extends VariantAbstractRPCQuery {
    public static final String JSON_RPC_CONTENT_TYPE = "application/json";
    public static final int NAME_SEPARATOR = 58;
    public static final int VALUE_SEPARATOR = 44;
    public static final int BEGIN_ARRAY = 91;
    public static final int QUOTATION_MARK = 34;
    public static final int BEGIN_OBJECT = 123;
    public static final int END_OBJECT = 125;
    public static final int END_ARRAY = 93;
    private SimpleStringReader sr;
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;

    @Override
    public boolean isValidContentType(String string) {
        return string.startsWith(JSON_RPC_CONTENT_TYPE);
    }

    @Override
    public void parseContent(String string) {
        this.sr = new SimpleStringReader(string);
        this.parseObject();
    }

    @Override
    public String getEscapedValue(String string, boolean bl) {
        String string2 = StringEscapeUtils.escapeJava((String)string);
        return bl ? 34 + string2 + 34 : string2;
    }

    @Override
    public String getUnescapedValue(String string) {
        return StringEscapeUtils.unescapeJava((String)string);
    }

    private void parseObject() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        while (!bl2) {
            switch (n) {
                case 0: {
                    int n2 = this.sr.skipWhitespaceRead();
                    if (n2 == 123) {
                        bl = true;
                        n2 = this.sr.skipWhitespaceRead();
                        if (n2 == 125) {
                            return;
                        }
                        this.sr.unreadLastCharacter();
                        n = 1;
                        break;
                    }
                    if (n2 == 91) {
                        this.sr.unreadLastCharacter();
                        n = 2;
                        break;
                    }
                    throw new IllegalArgumentException("Input is invalid JSON; does not start with '{' or '[', c=" + n2);
                }
                case 1: {
                    int n2 = this.sr.skipWhitespaceRead();
                    if (n2 == 34) {
                        int n3 = this.sr.getPosition();
                        while ((n2 = this.sr.read()) != 34) {
                            if (n2 != -1) continue;
                            throw new IllegalArgumentException("EOF reached while reading JSON field name");
                        }
                        int n4 = this.sr.getPosition();
                        string = this.getToken(n3, n4);
                        n2 = this.sr.skipWhitespaceRead();
                        if (n2 != 58) {
                            throw new IllegalArgumentException("Expected ':' between string field and value at position " + this.sr.getPosition());
                        }
                        this.sr.skipWhitespaceRead();
                        this.sr.unreadLastCharacter();
                        n = 2;
                        break;
                    }
                    throw new IllegalArgumentException("Expected quote at position " + this.sr.getPosition());
                }
                case 2: {
                    if (string == null) {
                        string = "@items";
                    }
                    this.parseValue(string);
                    n = 3;
                    break;
                }
                case 3: {
                    int n2 = this.sr.skipWhitespaceRead();
                    if (n2 == -1 && bl) {
                        throw new IllegalArgumentException("EOF reached before closing '}'");
                    }
                    if (n2 == 125 || n2 == -1) {
                        bl2 = true;
                        break;
                    }
                    if (n2 == 44) {
                        n = 1;
                        break;
                    }
                    throw new IllegalArgumentException("Object not ended with '}' or ']' at position " + this.sr.getPosition());
                }
            }
        }
    }

    private void parseValue(String string) {
        int n = this.sr.read();
        if (n == 34) {
            int n2 = this.sr.getPosition();
            while ((n = this.sr.read()) != 34) {
                if (n != -1) continue;
                throw new IllegalArgumentException("EOF reached while reading JSON field name");
            }
            this.addParameter(string, n2, this.sr.getPosition() - 1, false, true);
        } else if (Character.isDigit(n) || n == 45) {
            this.sr.unreadLastCharacter();
            int n3 = this.sr.getPosition();
            do {
                if ((n = this.sr.read()) != -1) continue;
                throw new IllegalArgumentException("Reached EOF while reading number");
            } while (Character.isDigit(n) || n == 46 || n == 101 || n == 69 || n == 43 || n == 45);
            this.sr.unreadLastCharacter();
            this.addParameter(string, n3, this.sr.getPosition() - 1, true, false);
        } else if (n == 123) {
            this.sr.unreadLastCharacter();
            this.parseObject();
        } else if (n == 91) {
            this.parseArray(string);
        } else if (n == 93) {
            this.sr.unreadLastCharacter();
        } else if (n == 116 || n == 84) {
            this.sr.unreadLastCharacter();
            this.parseToken("true");
        } else if (n == 102 || n == 70) {
            this.sr.unreadLastCharacter();
            this.parseToken("false");
        } else if (n == 110 || n == 78) {
            this.sr.unreadLastCharacter();
            this.parseToken("null");
        } else {
            if (n == -1) {
                throw new IllegalArgumentException("EOF reached prematurely");
            }
            throw new IllegalArgumentException("Unknown value type at position " + this.sr.getPosition());
        }
    }

    private void parseArray(String string) {
        block1: {
            int n;
            int n2 = 0;
            do {
                this.sr.skipWhitespaceRead();
                this.sr.unreadLastCharacter();
                this.parseValue(string + "[" + n2++ + "]");
                n = this.sr.skipWhitespaceRead();
                if (n == 93) break block1;
            } while (n == 44);
            throw new IllegalArgumentException("Expected ',' or ']' inside array at position " + this.sr.getPosition());
        }
    }

    private void parseToken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = this.sr.read();
            if (n2 == -1) {
                throw new IllegalArgumentException("EOF reached while reading token: " + string);
            }
            n2 = Character.toLowerCase((char)n2);
            char c = string.charAt(i);
            if (c == n2) continue;
            throw new IllegalArgumentException("Expected token: " + string + " at position " + this.sr.getPosition());
        }
    }

    protected class SimpleStringReader {
        private static final String WS = " \t\r\n";
        private String str;
        private int length;
        private int next = 0;

        public SimpleStringReader(String string) {
            this.str = string;
            this.length = string.length();
        }

        public int skipWhitespaceRead() {
            int n = this.read();
            while (WS.indexOf(n) != -1) {
                n = this.read();
            }
            return n;
        }

        public int read() {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        public void unreadLastCharacter() {
            --this.next;
        }

        public int getPosition() {
            return this.next;
        }
    }
}

