/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.view.TabbedPanel2;
import org.zaproxy.zap.view.ZapToggleButton;

public class BreakPanelToolbarFactory {
    private ContinueButtonAction continueButtonAction = new ContinueButtonAction();
    private StepButtonAction stepButtonAction = new StepButtonAction();
    private DropButtonAction dropButtonAction = new DropButtonAction();
    private AddBreakpointButtonAction addBreakpointButtonAction = new AddBreakpointButtonAction();
    private BreakRequestsButtonAction breakRequestsButtonAction = new BreakRequestsButtonAction();
    private BreakResponsesButtonAction breakResponsesButtonAction = new BreakResponsesButtonAction();
    private BreakAllButtonAction breakAllButtonAction = new BreakAllButtonAction();
    private boolean cont = false;
    private boolean step = false;
    private boolean stepping = false;
    private boolean drop = false;
    private boolean isBreakRequest = false;
    private boolean isBreakResponse = false;
    private boolean isBreakAll = false;
    private BreakPanel breakPanel = null;
    private BreakpointsParam breakpointsParams;
    private int mode = 0;

    public BreakPanelToolbarFactory(BreakpointsParam breakpointsParam, BreakPanel breakPanel) {
        this.breakpointsParams = breakpointsParam;
        this.breakPanel = breakPanel;
    }

    private void setActiveIcon(boolean bl) {
        if (bl) {
            this.breakPanel.setTabFocus();
        }
        if (this.breakPanel.getParent() instanceof TabbedPanel) {
            TabbedPanel tabbedPanel = (TabbedPanel)this.breakPanel.getParent();
            if (bl) {
                tabbedPanel.setIconAt(tabbedPanel.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101.png")));
            } else {
                tabbedPanel.setIconAt(tabbedPanel.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101grey.png")));
            }
            if (tabbedPanel instanceof TabbedPanel2) {
                ((TabbedPanel2)tabbedPanel).setTabLocked(this.breakPanel, !bl);
            }
        }
    }

    public void breakpointHit() {
        this.resetRequestSerialization(true);
        this.setActiveIcon(true);
        this.setContinue(false);
    }

    public boolean isBreakRequest() {
        return this.isBreakRequest || this.isBreakAll;
    }

    public boolean isBreakResponse() {
        return this.isBreakResponse || this.isBreakAll;
    }

    public boolean isBreakAll() {
        return this.isBreakAll;
    }

    public JButton getBtnStep() {
        return new JButton(this.stepButtonAction);
    }

    public JButton getBtnContinue() {
        return new JButton(this.continueButtonAction);
    }

    public JButton getBtnDrop() {
        return new JButton(this.dropButtonAction);
    }

    private int askForDropConfirmation() {
        String string = Constant.messages.getString("brk.dialogue.confirmDropMessage.title");
        String string2 = Constant.messages.getString("brk.dialogue.confirmDropMessage.message");
        JCheckBox jCheckBox = new JCheckBox(Constant.messages.getString("brk.dialogue.confirmDropMessage.option.dontAskAgain"));
        String string3 = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.confirm.label");
        String string4 = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.cancel.label");
        int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), new Object[]{string2, " ", jCheckBox}, string, 2, 3, null, new String[]{string3, string4}, null);
        if (jCheckBox.isSelected()) {
            this.breakpointsParams.setConfirmDropMessage(false);
        }
        return n;
    }

    public JToggleButton getBtnBreakRequest() {
        ZapToggleButton zapToggleButton = new ZapToggleButton(this.breakRequestsButtonAction);
        zapToggleButton.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105r.png")));
        zapToggleButton.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.request.unset"));
        return zapToggleButton;
    }

    public JToggleButton getBtnBreakResponse() {
        ZapToggleButton zapToggleButton = new ZapToggleButton(this.breakResponsesButtonAction);
        zapToggleButton.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106r.png")));
        zapToggleButton.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.response.unset"));
        return zapToggleButton;
    }

    public JToggleButton getBtnBreakAll() {
        ZapToggleButton zapToggleButton = new ZapToggleButton(this.breakAllButtonAction);
        zapToggleButton.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/151.png")));
        zapToggleButton.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.all.unset"));
        return zapToggleButton;
    }

    public JButton getBtnBreakPoint() {
        return new JButton(this.addBreakpointButtonAction);
    }

    public boolean isStepping() {
        return this.stepping;
    }

    private void resetRequestSerialization(boolean bl) {
        if (Control.getSingleton() == null) {
            return;
        }
        if (bl || this.isBreakRequest() || this.isBreakResponse() || this.isBreakAll) {
            Control.getSingleton().getProxy().setSerialize(true);
        } else {
            Control.getSingleton().getProxy().setSerialize(false);
        }
    }

    public void setBreakRequest(boolean bl) {
        this.isBreakRequest = bl;
        this.resetRequestSerialization(false);
        this.breakRequestsButtonAction.setSelected(this.isBreakRequest);
    }

    public void setBreakResponse(boolean bl) {
        this.isBreakResponse = bl;
        this.resetRequestSerialization(false);
        this.breakResponsesButtonAction.setSelected(this.isBreakResponse);
    }

    public void setBreakAll(boolean bl) {
        this.isBreakAll = bl;
        if (!bl) {
            this.stepping = false;
        }
        this.resetRequestSerialization(false);
        this.breakAllButtonAction.setSelected(this.isBreakAll);
    }

    private void toggleBreakRequest() {
        this.setBreakRequest(!this.isBreakRequest);
    }

    private void toggleBreakResponse() {
        this.setBreakResponse(!this.isBreakResponse);
    }

    private void toggleBreakAll() {
        this.setBreakAll(!this.isBreakAll);
    }

    public boolean isHoldMessage() {
        if (this.step) {
            this.stepping = true;
            this.step = false;
            return false;
        }
        if (this.cont) {
            this.stepping = false;
            this.resetRequestSerialization(false);
            return false;
        }
        return !this.drop;
    }

    public boolean isContinue() {
        return this.cont;
    }

    public void setBreakEnabled(boolean bl) {
        if (!bl) {
            this.isBreakRequest = false;
            this.isBreakResponse = false;
            this.isBreakAll = false;
            this.setContinue(true);
        }
        this.breakRequestsButtonAction.setSelected(false);
        this.breakRequestsButtonAction.setEnabled(bl);
        this.breakResponsesButtonAction.setSelected(false);
        this.breakResponsesButtonAction.setEnabled(bl);
        this.breakAllButtonAction.setSelected(false);
        this.breakAllButtonAction.setEnabled(bl);
    }

    private void setButtonsAndIconState(boolean bl) {
        this.stepButtonAction.setEnabled(bl);
        this.continueButtonAction.setEnabled(bl);
        this.dropButtonAction.setEnabled(bl);
        if (!bl) {
            this.setActiveIcon(false);
        }
    }

    protected void setContinue(boolean bl) {
        this.cont = bl;
        this.setButtonsAndIconState(!bl);
    }

    protected void setStep(boolean bl) {
        this.step = bl;
        this.setButtonsAndIconState(!bl);
    }

    protected void setDrop(boolean bl) {
        if (bl && this.breakpointsParams.isConfirmDropMessage() && this.askForDropConfirmation() != 0) {
            return;
        }
        this.drop = bl;
        this.setButtonsAndIconState(!bl);
    }

    public boolean isToBeDropped() {
        if (this.drop) {
            this.drop = false;
            return true;
        }
        return false;
    }

    public void init() {
        this.cont = false;
        this.step = false;
        this.stepping = false;
        this.drop = false;
        this.isBreakRequest = false;
        this.isBreakResponse = false;
        this.isBreakAll = false;
    }

    public void reset() {
        if (this.isBreakRequest()) {
            this.toggleBreakRequest();
        }
        if (this.isBreakResponse()) {
            this.toggleBreakResponse();
        }
        if (this.isBreakAll()) {
            this.toggleBreakAll();
        }
        this.setContinue(true);
    }

    public void setButtonMode(int n) {
        if (this.mode == n) {
            return;
        }
        if (this.mode == 1) {
            if (this.isBreakAll) {
                this.setBreakAll(false);
                this.setBreakRequest(true);
                this.setBreakResponse(true);
            }
        } else if (this.isBreakRequest || this.isBreakResponse) {
            this.setBreakRequest(false);
            this.setBreakResponse(false);
            this.setBreakAll(true);
        }
        this.mode = n;
    }

    private static abstract class SelectableAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SelectableAbstractAction(String string, Icon icon) {
            super(string, icon);
        }

        public void setSelected(boolean bl) {
            this.putValue("SwingSelectedKey", bl);
        }
    }

    private class BreakAllButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakAllButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/152.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.all.set"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.toggleBreakAll();
        }
    }

    private class BreakResponsesButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakResponsesButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.response.set"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.toggleBreakResponse();
        }
    }

    private class BreakRequestsButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakRequestsButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.request.set"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.toggleBreakRequest();
        }
    }

    private class AddBreakpointButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddBreakpointButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/break_add.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkpoint"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.breakPanel.showNewBreakPointDialog();
        }
    }

    private class DropButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DropButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/150.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.bin"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.setDrop(true);
        }
    }

    private class StepButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StepButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/143.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.step"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BreakPanelToolbarFactory.this.mode == 1 && !BreakPanelToolbarFactory.this.isBreakAll) {
                BreakPanelToolbarFactory.this.setContinue(true);
            } else {
                BreakPanelToolbarFactory.this.setStep(true);
            }
        }
    }

    private class ContinueButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ContinueButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/131.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.cont"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BreakPanelToolbarFactory.this.setContinue(true);
            BreakPanelToolbarFactory.this.setBreakAll(false);
            BreakPanelToolbarFactory.this.setBreakRequest(false);
            BreakPanelToolbarFactory.this.setBreakResponse(false);
        }
    }
}

