/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionInfo;
import Ice.Endpoint;
import Ice.Exception;
import Ice.InputStream;
import Ice.Instrumentation.ChildInvocationObserver;
import Ice.ObjectAdapter;
import Ice.OutputStream;
import IceInternal.AsyncResultI;
import IceInternal.CallbackBase;
import IceInternal.Instance;
import IceInternal.Protocol;

public abstract class OutgoingAsyncBase
extends AsyncResultI {
    protected OutputStream _os;
    protected ChildInvocationObserver _childObserver;

    public boolean sent() {
        return this.sent(true);
    }

    public boolean completed(InputStream is) {
        assert (false);
        return false;
    }

    public boolean completed(Exception ex) {
        return this.finished(ex);
    }

    public final void attachRemoteObserver(ConnectionInfo info, Endpoint endpt, int requestId) {
        if (this._observer != null) {
            int size = this._os.size() - 14 - 4;
            this._childObserver = this.getObserver().getRemoteObserver(info, endpt, requestId, size);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    public final void attachCollocatedObserver(ObjectAdapter adapter, int requestId) {
        if (this._observer != null) {
            int size = this._os.size() - 14 - 4;
            this._childObserver = this.getObserver().getCollocatedObserver(adapter, requestId, size);
            if (this._childObserver != null) {
                this._childObserver.attach();
            }
        }
    }

    public final OutputStream getOs() {
        return this._os;
    }

    protected OutgoingAsyncBase(Communicator com, Instance instance, String op, CallbackBase del) {
        super(com, instance, op, del);
        this._os = new OutputStream(instance, Protocol.currentProtocolEncoding);
    }

    protected OutgoingAsyncBase(Communicator com, Instance instance, String op, CallbackBase del, OutputStream os) {
        super(com, instance, op, del);
        this._os = os;
    }

    @Override
    protected boolean sent(boolean done) {
        if (done && this._childObserver != null) {
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.sent(done);
    }

    @Override
    protected boolean finished(Exception ex) {
        if (this._childObserver != null) {
            this._childObserver.failed(ex.ice_id());
            this._childObserver.detach();
            this._childObserver = null;
        }
        return super.finished(ex);
    }
}

