#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.2.2
id: hackage-security-0.5.2.2-K7Hii18vR2BJeeM2SQ3yHs
key: hackage-security-0.5.2.2-K7Hii18vR2BJeeM2SQ3yHs
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
indefinite: False
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: 2c510d047fdf50f401db7462fcf0bb9b
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/hackage-security-0.5.2.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/hackage-security-0.5.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/hackage-security-0.5.2.2
hs-libraries: HShackage-security-0.5.2.2-K7Hii18vR2BJeeM2SQ3yHs
depends:
    base-4.10.0.0 base16-bytestring-0.1.1.6-1RelFaTH3mXDxpXrCeJSko
    base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm
    bytestring-0.10.8.2 Cabal-2.0.0.2 containers-0.5.10.2
    directory-1.3.0.2 ed25519-0.0.5.0-9NT4KzgzBhXCnbKiU3eJSo
    filepath-1.4.1.2 mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh pretty-1.1.3.3
    cryptohash-sha256-0.11.101.0-I1K3fYbQvGGIBL2HcVgfRG
    tar-0.5.0.3-INtpRXtFzzEKq72z4RSP9M time-1.8.0.2
    transformers-0.5.2.0 zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB
    template-haskell-2.12.0.0 ghc-prim-0.5.1.0
    network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base16-bytestring-0.1.1.6-1RelFaTH3mXDxpXrCeJSko=e16826576c05906da343512ae9616ea8
             base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm=d31f9783df40d231323e9ab91d44fa81
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             Cabal-2.0.0.2=c8eb33a4731ce0ca1f6ddb3df7f6d80c
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             ed25519-0.0.5.0-9NT4KzgzBhXCnbKiU3eJSo=fd27f601ab70fec75cd9603479d6a7ac
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             pretty-1.1.3.3=5491220463456849eb660c64bb0df8c8
             cryptohash-sha256-0.11.101.0-I1K3fYbQvGGIBL2HcVgfRG=442b13fccd534b31a786499ec341d1bb
             tar-0.5.0.3-INtpRXtFzzEKq72z4RSP9M=537fd462573572155fedd756721a4cd6
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB=f9a6b8e404d4e5df9363e7202bb41dfe
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             ghc-prim-0.5.1.0=557c7fce76ef13c2417583cc28848f14
             network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK=83774d660ce535b1c7a882f242c5fec6
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

