#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.2.1
id: semigroupoids-5.2.1-BrFpsm3Xb4SLTmLSosQvtp
key: semigroupoids-5.2.1-BrFpsm3Xb4SLTmLSosQvtp
license: BSD3
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
exposed: True
indefinite: False
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
abi: 4a7eb4dea61c6f90c822c8a91f086fa5
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/semigroupoids-5.2.1
library-dirs: /usr/lib/ghc-8.2.1/site-local/semigroupoids-5.2.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/semigroupoids-5.2.1
hs-libraries: HSsemigroupoids-5.2.1-BrFpsm3Xb4SLTmLSosQvtp
depends:
    base-4.10.0.0 base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L
    bifunctors-5.4.2-EkvLHEGusmL2QBUCGZ7PSE
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP transformers-0.5.2.0
    transformers-compat-0.5.1.4-8ofY1OHzPhX5dvYk512o2v
    containers-0.5.10.2 contravariant-1.4-1lqq0vqix8Y43XZ7Q5hTLe
    distributive-0.5.3-99ryfobDi0e5qzYasSVH5G
    comonad-5.0.2-AAFyIh6Dm39islDxts6T3
    tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-orphans-0.6-9iPDLrUqQ5yHb9fb9OUZ9L=80bc3cbc1a27ff088178ac694da5ed41
             bifunctors-5.4.2-EkvLHEGusmL2QBUCGZ7PSE=3c661fc7707c57e8dca3d6cba12d1535
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             transformers-compat-0.5.1.4-8ofY1OHzPhX5dvYk512o2v=e48d0ae1a0338f5c9f46149b634d1da7
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             contravariant-1.4-1lqq0vqix8Y43XZ7Q5hTLe=893af150e87a363f17ac42bee5d29045
             distributive-0.5.3-99ryfobDi0e5qzYasSVH5G=696e7055a26e1c2a28fbdde9c9afe158
             comonad-5.0.2-AAFyIh6Dm39islDxts6T3=2e229087fcf32b235bcf466fea4261ee
             tagged-0.8.5-7Kuk6etyDBjGPRKMYpsbFG=fee9dd37afd44fe7a6a3e8c00aaf438e
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

