#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.0.3
id: pandoc-2.0.3-27H0I5ezHhX4qU4nUuzDkd
key: pandoc-2.0.3-27H0I5ezHhX4qU4nUuzDkd
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, and several kinds of HTML/JavaScript slide
    shows (S5, Slidy, Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Lua.PandocModule
                Text.Pandoc.Lua.Filter Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Text.Pandoc.Compat.Time Paths_pandoc
abi: d57ce7ae49733b8e9c680368eeae0198
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/pandoc-2.0.3
library-dirs: /usr/lib/ghc-8.2.1/site-local/pandoc-2.0.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.0.3-27H0I5ezHhX4qU4nUuzDkd
depends:
    base-4.10.0.0 syb-0.7-2rRPTNxBP6YFePrCXw4i2o containers-0.5.10.2
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 filepath-1.4.1.2 process-1.6.1.0
    directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    zip-archive-0.3.1.1-CZhWVZnrHky8oZZ6YlWuu5
    HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV
    texmath-0.10-8wEcLUU2Uju8wFqcFjNSLQ
    xml-1.3.14-5OPJvPT6yGP6QU1NbG18WH
    split-0.2.3.2-89BHvn20PlL73pGr1SBIHj
    random-1.1-DtLcP2Z2iOOC0RwcSmXjBK
    pandoc-types-1.17.3-3ez989VQsU1J0DOvUecTA3
    aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq
    aeson-pretty-0.8.5-9BxbFsM21RbE8Yp2sqULuj
    tagsoup-0.14.1-Dd68OXPvIKPH8wN6EGE1ft
    base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm
    zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB
    skylighting-0.4.4-AJlZNIxDSeA7UVT4yuheYt
    data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J
    temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo
    blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh
    blaze-markup-0.8.0.0-FzqDX3sF5iY7olwigbNHfL
    yaml-0.8.25-KXLr76T0yGA4mwXZdRjC8Y
    scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    hslua-0.9.2-JbgUqlJnTQq9SWufpM4nMb
    hslua-module-text-0.1.2.1-AxcuefJGxYKF1UQ3r9N7Io binary-0.8.5.1
    SHA-1.6.4.2-CLjgfR8MPKbGDDn0VxSSuZ
    haddock-library-1.4.5-1OmnnNPZUScA7ST5GunZse deepseq-1.4.3.0
    JuicyPixels-3.2.9.1-IPtX6eqoMTN8RSIy4DNcbT
    Glob-0.7.14-EWXJTNKCxct7qBMI2wP4uQ
    cmark-gfm-0.1.3-NkbstHccCPJuTcaZ0pNPy
    doctemplates-0.2.1-EF0D14UYWVr1YDDAHiA8vo
    http-client-0.5.7.1-3lJEt29GZp278eofO9V2MK
    http-client-tls-0.3.5.1-2Qxzl5p0xOVULSMlS1Tif
    http-types-0.9.1-4bB5vMj0wc7H0s2DJoYpPW
    case-insensitive-1.2.0.10-G6p6xuzQuZQOyTREOVUmI unix-2.7.2.2
    time-1.8.0.2 network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             syb-0.7-2rRPTNxBP6YFePrCXw4i2o=119e2c6ac6f570dd5e30835fe9c8c288
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             zip-archive-0.3.1.1-CZhWVZnrHky8oZZ6YlWuu5=587ffcd0be19d71fe664743fc57fbf10
             HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV=ad16a0554ab273a5de2536f4ea3143c2
             texmath-0.10-8wEcLUU2Uju8wFqcFjNSLQ=b6ff7a82d951224b66eca19df5d2893f
             xml-1.3.14-5OPJvPT6yGP6QU1NbG18WH=0fb3db3aece5460bbed64ec858b0682d
             split-0.2.3.2-89BHvn20PlL73pGr1SBIHj=c51f43c3e91d41531ae5282d108271a0
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             pandoc-types-1.17.3-3ez989VQsU1J0DOvUecTA3=f532409688b889b3a515baf49102da61
             aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq=61053bde0c5cda47d1a123db05d36888
             aeson-pretty-0.8.5-9BxbFsM21RbE8Yp2sqULuj=32cd10ac9c8dd84a8b4e2e5c8775464b
             tagsoup-0.14.1-Dd68OXPvIKPH8wN6EGE1ft=8f9438479e2b7a3df6cc973be04bc206
             base64-bytestring-1.0.0.1-D9uFxOosRHvGwKtuClA6fm=d31f9783df40d231323e9ab91d44fa81
             zlib-0.6.1.2-6xNZGE39eOa1IjQdEzckzB=f9a6b8e404d4e5df9363e7202bb41dfe
             skylighting-0.4.4-AJlZNIxDSeA7UVT4yuheYt=46a8495687788b3d924a22598d9d9d24
             data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J=51023526c672e559ef5f8b366e37519b
             temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo=ba806cd7fa58c88cefcf360552466b99
             blaze-html-0.9.0.1-kPi4af1DH04kfw48f7OOh=4d7402d6bc242682528205229a7d9db9
             blaze-markup-0.8.0.0-FzqDX3sF5iY7olwigbNHfL=8112a13be358d1f890474077a94c9c8e
             yaml-0.8.25-KXLr76T0yGA4mwXZdRjC8Y=f02d8f40a7e2572d2eefded08e0a6898
             scientific-0.3.5.2-KczHvPTRxl0EYfM8aLeb6Q=1fbe9fca72112f81835ace86a6280857
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             hslua-0.9.2-JbgUqlJnTQq9SWufpM4nMb=733cdaa070169a3e7992f5b353d2612b
             hslua-module-text-0.1.2.1-AxcuefJGxYKF1UQ3r9N7Io=04ec53dc380c2de81d640a55357aad3d
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             SHA-1.6.4.2-CLjgfR8MPKbGDDn0VxSSuZ=31a3ba5e9f60e459d949cb8614b89a69
             haddock-library-1.4.5-1OmnnNPZUScA7ST5GunZse=b7808870b641c25bf34bab2e7fa9fdd1
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             JuicyPixels-3.2.9.1-IPtX6eqoMTN8RSIy4DNcbT=145d400d135983f6a1e1451b705b5f4e
             Glob-0.7.14-EWXJTNKCxct7qBMI2wP4uQ=824d1e8af2b3d95d0e931978f39f0ab5
             cmark-gfm-0.1.3-NkbstHccCPJuTcaZ0pNPy=12090845e10d3789d63e926a3251ac4c
             doctemplates-0.2.1-EF0D14UYWVr1YDDAHiA8vo=77f15e89609793a12b5c4e862e5bf733
             http-client-0.5.7.1-3lJEt29GZp278eofO9V2MK=ed53fa9034189e5dd3b2e3936be4ddab
             http-client-tls-0.3.5.1-2Qxzl5p0xOVULSMlS1Tif=9778187c064b245b8a4d3cb3a178df5f
             http-types-0.9.1-4bB5vMj0wc7H0s2DJoYpPW=8bdb3e32f976a0904554b35642e32260
             case-insensitive-1.2.0.10-G6p6xuzQuZQOyTREOVUmI=f9fb05439242cab6e496c322f2a1e33a
             unix-2.7.2.2=7af8630098b53e228272ffaea5bacf62
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK=83774d660ce535b1c7a882f242c5fec6
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

