/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ParamsGroup
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)ParamsGroup.class.getName());
    private String myGroupId;
    private ParametersList myGroupParams;

    public ParamsGroup(@NotNull String groupId) {
        if (groupId == null) {
            ParamsGroup.$$$reportNull$$$0(0);
        }
        this.myGroupParams = new ParametersList();
        this.myGroupId = groupId;
    }

    public String getId() {
        return this.myGroupId;
    }

    public void addParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParamsGroup.$$$reportNull$$$0(1);
        }
        this.myGroupParams.add(parameter);
    }

    public void addParameterAt(int index, @NotNull @NonNls String parameter) {
        if (parameter == null) {
            ParamsGroup.$$$reportNull$$$0(2);
        }
        this.myGroupParams.addAt(index, parameter);
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            ParamsGroup.$$$reportNull$$$0(3);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            ParamsGroup.$$$reportNull$$$0(4);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParametersString(@NotNull @NonNls String parametersString) {
        if (parametersString == null) {
            ParamsGroup.$$$reportNull$$$0(5);
        }
        this.addParameters(ParametersList.parse(parametersString));
    }

    public List<String> getParameters() {
        return this.myGroupParams.getList();
    }

    public ParametersList getParametersList() {
        return this.myGroupParams;
    }

    public ParamsGroup clone() {
        try {
            ParamsGroup clone = (ParamsGroup)super.clone();
            clone.myGroupId = this.myGroupId;
            clone.myGroupParams = this.myGroupParams.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.myGroupId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersString";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/configurations/ParamsGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameterAt";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addParametersString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

