/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInputFilter
implements InputFilter {
    private static final Logger LOG = Logger.getInstance(CompositeInputFilter.class);
    private final List<Pair<InputFilter, Boolean>> myFilters;
    private final DumbService myDumbService;

    public CompositeInputFilter(@NotNull Project project) {
        if (project == null) {
            CompositeInputFilter.$$$reportNull$$$0(0);
        }
        this.myFilters = ContainerUtilRt.newArrayList();
        this.myDumbService = DumbService.getInstance(project);
    }

    @Override
    @Nullable
    public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, ConsoleViewContentType contentType) {
        if (text == null) {
            CompositeInputFilter.$$$reportNull$$$0(1);
        }
        boolean dumb = this.myDumbService.isDumb();
        for (Pair<InputFilter, Boolean> pair : this.myFilters) {
            if (dumb && pair.second != Boolean.TRUE) continue;
            long t0 = System.currentTimeMillis();
            InputFilter filter = (InputFilter)pair.first;
            List<Pair<String, ConsoleViewContentType>> result = filter.applyFilter(text, contentType);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 100L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + text + "'''");
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addFilter(final @NotNull InputFilter filter) {
        if (filter == null) {
            CompositeInputFilter.$$$reportNull$$$0(2);
        }
        InputFilter wrapper = new InputFilter(){
            boolean isBroken;

            @Override
            @Nullable
            public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, ConsoleViewContentType contentType) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.isBroken) {
                    try {
                        return filter.applyFilter(text, contentType);
                    }
                    catch (ProcessCanceledException ignored) {
                        ProgressManager.checkCanceled();
                    }
                    catch (Throwable e) {
                        this.isBroken = true;
                        LOG.error(e);
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/filters/CompositeInputFilter$1", "applyFilter"));
            }
        };
        this.myFilters.add((Pair<InputFilter, Boolean>)Pair.create((Object)wrapper, (Object)DumbService.isDumbAware(filter)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/CompositeInputFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

