/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentDescriptor
implements Disposable {
    public static final Key<RunContentDescriptor> DESCRIPTOR_KEY = Key.create((String)"Descriptor");
    private ExecutionConsole myExecutionConsole;
    private ProcessHandler myProcessHandler;
    private JComponent myComponent;
    private final String myDisplayName;
    private final Icon myIcon;
    private final String myHelpId;
    private RunnerLayoutUi myRunnerLayoutUi;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myReuseToolWindowActivation;
    private long myExecutionId;
    private Computable<JComponent> myFocusComputable;
    private boolean myAutoFocusContent;
    private Content myContent;
    private String myContentToolWindowId;
    @NotNull
    private final AnAction[] myRestartActions;
    @Nullable
    private final Runnable myActivationCallback;

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(0);
        }
        this(executionConsole, processHandler, component, displayName, icon, activationCallback, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon, @Nullable Runnable activationCallback, @Nullable AnAction[] restartActions) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(1);
        }
        this.myRunnerLayoutUi = null;
        this.myActivateToolWindowWhenAdded = true;
        this.myReuseToolWindowActivation = false;
        this.myExecutionId = 0L;
        this.myFocusComputable = null;
        this.myAutoFocusContent = false;
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myHelpId = this.myExecutionConsole instanceof HelpIdProvider ? ((HelpIdProvider)((Object)this.myExecutionConsole)).getHelpId() : null;
        this.myActivationCallback = activationCallback;
        if (this.myExecutionConsole != null) {
            Disposer.register((Disposable)this, (Disposable)this.myExecutionConsole);
        }
        this.myRestartActions = restartActions == null ? AnAction.EMPTY_ARRAY : restartActions;
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName, @Nullable Icon icon) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(2);
        }
        this(executionConsole, processHandler, component, displayName, icon, null, null);
    }

    public RunContentDescriptor(@Nullable ExecutionConsole executionConsole, @Nullable ProcessHandler processHandler, @NotNull JComponent component, String displayName) {
        if (component == null) {
            RunContentDescriptor.$$$reportNull$$$0(3);
        }
        this(executionConsole, processHandler, component, displayName, null, null, null);
    }

    public RunContentDescriptor(@NotNull RunProfile profile, @NotNull ExecutionResult executionResult, @NotNull RunnerLayoutUi ui) {
        if (profile == null) {
            RunContentDescriptor.$$$reportNull$$$0(4);
        }
        if (executionResult == null) {
            RunContentDescriptor.$$$reportNull$$$0(5);
        }
        if (ui == null) {
            RunContentDescriptor.$$$reportNull$$$0(6);
        }
        this(executionResult.getExecutionConsole(), executionResult.getProcessHandler(), ui.getComponent(), profile.getName(), profile.getIcon(), null, executionResult instanceof DefaultExecutionResult ? ((DefaultExecutionResult)executionResult).getRestartActions() : null);
        this.myRunnerLayoutUi = ui;
    }

    public Runnable getActivationCallback() {
        return this.myActivationCallback;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        AnAction[] anActionArray = this.myRestartActions.length == 0 ? AnAction.EMPTY_ARRAY : (AnAction[])this.myRestartActions.clone();
        if (anActionArray == null) {
            RunContentDescriptor.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        this.myExecutionConsole = null;
        this.myComponent = null;
        this.myProcessHandler = null;
        this.myContent = null;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public Content getAttachedContent() {
        return this.myContent;
    }

    public void setAttachedContent(@NotNull Content content) {
        if (content == null) {
            RunContentDescriptor.$$$reportNull$$$0(8);
        }
        this.myContent = content;
    }

    @Nullable
    public String getContentToolWindowId() {
        return this.myContentToolWindowId;
    }

    public void setContentToolWindowId(String contentToolWindowId) {
        this.myContentToolWindowId = contentToolWindowId;
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isReuseToolWindowActivation() {
        return this.myReuseToolWindowActivation;
    }

    public void setReuseToolWindowActivation(boolean reuseToolWindowActivation) {
        this.myReuseToolWindowActivation = reuseToolWindowActivation;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.hashCode() + "(" + this.getDisplayName() + ")";
    }

    public Computable<JComponent> getPreferredFocusComputable() {
        return this.myFocusComputable;
    }

    public void setFocusComputable(Computable<JComponent> focusComputable) {
        this.myFocusComputable = focusComputable;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerLayoutUi;
    }

    public void setRunnerLayoutUi(@Nullable RunnerLayoutUi runnerLayoutUi) {
        this.myRunnerLayoutUi = runnerLayoutUi;
    }

    @ApiStatus.Experimental
    public boolean isHiddenContent() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunContentDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunContentDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestartActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAttachedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

