/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="splitter-proportions")
public class SplitterProportionsDataImpl
implements SplitterProportionsData {
    private static final String DATA_VERSION = "1";
    @NonNls
    private static final String ATTRIBUTE_PROPORTIONS = "proportions";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private List<Float> proportions = new SmartList();

    @Override
    public void saveSplitterProportions(Component root) {
        this.proportions.clear();
        this.doSaveSplitterProportions(root);
    }

    private void doSaveSplitterProportions(Component root) {
        if (root instanceof Splitter) {
            Float prop = Float.valueOf(((Splitter)root).getProportion());
            this.proportions.add(prop);
        }
        if (root instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)root).getComponents()) {
                this.doSaveSplitterProportions(child);
            }
        }
    }

    @Override
    public void restoreSplitterProportions(Component root) {
        this.restoreSplitterProportions(root, 0);
    }

    private int restoreSplitterProportions(Component root, int index) {
        if (root instanceof Splitter) {
            if (this.proportions.size() <= index) {
                return index;
            }
            ((Splitter)root).setProportion(this.proportions.get(index++).floatValue());
        }
        if (root instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)root).getComponents()) {
                index = this.restoreSplitterProportions(child, index);
            }
        }
        return index;
    }

    @Override
    public void externalizeToDimensionService(String key) {
        for (int i = 0; i < this.proportions.size(); ++i) {
            PropertiesComponent.getInstance().setValue(key + "." + i, (int)(this.proportions.get(i).floatValue() * 1000.0f), -1);
        }
    }

    @Override
    public void externalizeFromDimensionService(String key) {
        int value;
        this.proportions.clear();
        int i = 0;
        while ((value = PropertiesComponent.getInstance().getInt(key + "." + i, -1)) != -1) {
            this.proportions.add(new Float((double)value * 0.001));
            ++i;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.proportions.clear();
        String prop = element.getAttributeValue(ATTRIBUTE_PROPORTIONS);
        String version = element.getAttributeValue(ATTRIBUTE_VERSION);
        if (prop != null && Comparing.equal((String)version, (String)DATA_VERSION)) {
            StringTokenizer tokenizer = new StringTokenizer(prop, ",");
            while (tokenizer.hasMoreTokens()) {
                String p = tokenizer.nextToken();
                this.proportions.add(Float.valueOf(p));
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Float proportion : this.proportions) {
            result.append(sep);
            result.append(proportion);
            sep = ",";
        }
        element.setAttribute(ATTRIBUTE_PROPORTIONS, result.toString());
        element.setAttribute(ATTRIBUTE_VERSION, DATA_VERSION);
    }

    public List<Float> getProportions() {
        return this.proportions;
    }

    public void setProportions(List<Float> proportions) {
        this.proportions = proportions;
    }

    public boolean equals(Object obj) {
        return obj instanceof SplitterProportionsDataImpl && ((SplitterProportionsDataImpl)obj).getProportions().equals(this.proportions);
    }

    public static final class SplitterProportionsConverter
    extends Converter<SplitterProportionsDataImpl> {
        @Nullable
        public SplitterProportionsDataImpl fromString(@NotNull String value) {
            if (value == null) {
                SplitterProportionsConverter.$$$reportNull$$$0(0);
            }
            SplitterProportionsDataImpl data = new SplitterProportionsDataImpl();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                data.proportions.add(Float.valueOf(tokenizer.nextToken()));
            }
            return data;
        }

        @NotNull
        public String toString(@NotNull SplitterProportionsDataImpl data) {
            if (data == null) {
                SplitterProportionsConverter.$$$reportNull$$$0(1);
            }
            StringBuilder result = new StringBuilder();
            String sep = "";
            for (Float proportion : data.proportions) {
                result.append(sep);
                result.append(proportion);
                sep = ",";
            }
            String string = result.toString();
            if (string == null) {
                SplitterProportionsConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/SplitterProportionsDataImpl$SplitterProportionsConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/SplitterProportionsDataImpl$SplitterProportionsConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

