/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class RemoveUsageAction
extends AnAction {
    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(RemoveUsageAction.getUsages(e).length > 0);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        RemoveUsageAction.process(RemoveUsageAction.getUsages(e), e.getData(UsageView.USAGE_VIEW_KEY));
    }

    private static void process(@NotNull Usage[] usages, @NotNull UsageView usageView) {
        if (usages == null) {
            RemoveUsageAction.$$$reportNull$$$0(0);
        }
        if (usageView == null) {
            RemoveUsageAction.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (usages.length == 0) {
            return;
        }
        Arrays.sort(usages, UsageViewImpl.USAGE_COMPARATOR);
        Usage nextToSelect = RemoveUsageAction.getNextToSelect(usageView, usages[usages.length - 1]);
        for (Usage usage : usages) {
            usageView.removeUsage(usage);
        }
        if (nextToSelect != null) {
            usageView.selectUsages(new Usage[]{nextToSelect});
        }
    }

    @NotNull
    private static Usage[] getUsages(AnActionEvent context) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageView usageView = context.getData(UsageView.USAGE_VIEW_KEY);
        if (usageView == null) {
            if (Usage.EMPTY_ARRAY == null) {
                RemoveUsageAction.$$$reportNull$$$0(2);
            }
            return Usage.EMPTY_ARRAY;
        }
        Usage[] usages = context.getData(UsageView.USAGES_KEY);
        Usage[] usageArray = usages == null ? Usage.EMPTY_ARRAY : usages;
        if (usageArray == null) {
            RemoveUsageAction.$$$reportNull$$$0(3);
        }
        return usageArray;
    }

    private static Usage getNextToSelect(@NotNull UsageView usageView, @NotNull Usage toDelete) {
        if (usageView == null) {
            RemoveUsageAction.$$$reportNull$$$0(4);
        }
        if (toDelete == null) {
            RemoveUsageAction.$$$reportNull$$$0(5);
        }
        return ((UsageViewImpl)usageView).getNextToSelect(toDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/actions/RemoveUsageAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/actions/RemoveUsageAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextToSelect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

