/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatChangedTextUtil {
    public static final Key<CharSequence> TEST_REVISION_CONTENT = Key.create((String)"test.revision.content");
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    protected FormatChangedTextUtil() {
    }

    @NotNull
    public static FormatChangedTextUtil getInstance() {
        FormatChangedTextUtil formatChangedTextUtil = (FormatChangedTextUtil)ServiceManager.getService(FormatChangedTextUtil.class);
        if (formatChangedTextUtil == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(0);
        }
        return formatChangedTextUtil;
    }

    public static boolean hasChanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(1);
        }
        Project project = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory2) {
        if (directory2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(2);
        }
        return FormatChangedTextUtil.hasChanges(directory2.getVirtualFile(), directory2.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(4);
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file2);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files, @NotNull Project project) {
        if (files == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(6);
        }
        for (VirtualFile file2 : files) {
            if (!FormatChangedTextUtil.hasChanges(file2, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module2) {
        if (module2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(7);
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module2.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(final @NotNull Project project) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(8);
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(@NotNull Result<ModifiableModuleModel> result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.setResult((Object)ModuleManager.getInstance((Project)project).getModifiableModel());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/actions/FormatChangedTextUtil$1", "run"));
            }
        }.execute().getResultObject();
        try {
            for (Module module2 : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<PsiDirectory> dirs) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(9);
        }
        if (dirs == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(10);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes = ContainerUtil.newArrayList();
        for (PsiDirectory dir : dirs) {
            changes.addAll(changeListManager.getChangesIn(dir.getVirtualFile()));
        }
        List<PsiFile> list2 = FormatChangedTextUtil.getChangedFiles(project, changes);
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(final @NotNull Project project, @NotNull Collection<Change> changes) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(12);
        }
        if (changes == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(13);
        }
        Function<Change, PsiFile> changeToPsiFileMapper = new Function<Change, PsiFile>(){
            private PsiManager myPsiManager;
            {
                this.myPsiManager = PsiManager.getInstance((Project)project);
            }

            public PsiFile fun(Change change) {
                VirtualFile vFile = change.getVirtualFile();
                return vFile != null ? this.myPsiManager.findFile(vFile) : null;
            }
        };
        List list2 = ContainerUtil.mapNotNull(changes, (Function)changeToPsiFileMapper);
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(18);
        }
        if (contentFromVcs == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(19);
        }
        return -1;
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        if (project == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(21);
        }
        return false;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) throws FilesTooBigForDiffException {
        if (file2 == null) {
            FormatChangedTextUtil.$$$reportNull$$$0(22);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/FormatChangedTextUtil";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/FormatChangedTextUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFilesFromDirs";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasChanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesFromDirs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

