/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.XmlTokenSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlTagImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlSelectioner
extends AbstractWordSelectioner {
    private static final SelectWordUtil.CharCondition JAVA_IDENTIFIER_AND_HYPHEN_CONDITION = ch -> Character.isJavaIdentifierPart(ch) || ch == '-';

    @Override
    public boolean canSelect(PsiElement e) {
        return HtmlSelectioner.canSelectElement(e);
    }

    static boolean canSelectElement(PsiElement e) {
        if (e instanceof XmlToken || PsiTreeUtil.getParentOfType((PsiElement)e, HtmlTagImpl.class, (boolean)true) != null) {
            return HtmlUtil.hasHtml(e.getContainingFile()) || HtmlUtil.supportsXmlTypedHandlers(e.getContainingFile());
        }
        return false;
    }

    @Override
    public List<TextRange> select(PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(1);
        }
        ArrayList result2 = !(e instanceof XmlToken) || XmlTokenSelectioner.shouldSelectToken((XmlToken)e) || ((XmlToken)e).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS ? super.select(e, editorText, cursorOffset, editor) : ContainerUtil.newArrayList();
        PsiElement parent = e.getParent();
        if (parent instanceof XmlComment) {
            result2.addAll(HtmlSelectioner.expandToWholeLine(editorText, parent.getTextRange(), true));
        }
        PsiFile psiFile = e.getContainingFile();
        this.addAttributeSelection(result2, editor, cursorOffset, editorText, e);
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        for (Language lang : fileViewProvider.getLanguages()) {
            PsiFile langFile = fileViewProvider.getPsi(lang);
            if (langFile == psiFile) continue;
            this.addAttributeSelection(result2, editor, cursorOffset, editorText, fileViewProvider.findElementAt(cursorOffset, lang));
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)e.getProject(), (VirtualFile)psiFile.getVirtualFile());
        highlighter.setText(editorText);
        HtmlSelectioner.addTagSelection2(e, result2);
        return result2;
    }

    private static void addTagSelection2(PsiElement e, List<TextRange> result2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class, (boolean)true);
        while (tag != null) {
            result2.add(tag.getTextRange());
            ASTNode tagStartEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            ASTNode tagEndStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
            if (tagStartEnd != null && tagEndStart != null) {
                result2.add((TextRange)new UnfairTextRange(tagStartEnd.getTextRange().getEndOffset(), tagEndStart.getTextRange().getStartOffset()));
            }
            if (tagStartEnd != null) {
                result2.add(new TextRange(tag.getTextRange().getStartOffset(), tagStartEnd.getTextRange().getEndOffset()));
            }
            if (tagEndStart != null) {
                result2.add(new TextRange(tagEndStart.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset()));
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        }
    }

    private void addAttributeSelection(@NotNull List<TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @Nullable PsiElement e) {
        XmlAttribute attribute;
        if (result2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(3);
        }
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(4);
        }
        if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class)) != null) {
            result2.add(attribute.getTextRange());
            XmlAttributeValue value = attribute.getValueElement();
            if (value != null) {
                if (this.getClassAttributeName().equalsIgnoreCase(attribute.getName())) {
                    HtmlSelectioner.addClassAttributeRanges(result2, editor, cursorOffset, editorText, value);
                }
                TextRange range = value.getTextRange();
                result2.add(range);
                if (value.getFirstChild() != null && value.getFirstChild().getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    result2.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
                }
            }
        }
    }

    @Override
    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (element == null) {
            HtmlSelectioner.$$$reportNull$$$0(5);
        }
        if (text == null) {
            HtmlSelectioner.$$$reportNull$$$0(6);
        }
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            TextRange valueTextRange;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
            if (attribute != null && attributeValue != null && this.getClassAttributeName().equalsIgnoreCase(attribute.getName()) && !(valueTextRange = attributeValue.getValueTextRange()).isEmpty()) {
                int start;
                int end = cursorOffset;
                for (start = cursorOffset; start > valueTextRange.getStartOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text.charAt(start - 1)); --start) {
                }
                while (end < valueTextRange.getEndOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text.charAt(end + 1))) {
                    ++end;
                }
                return end - start;
            }
        }
        return super.getMinimalTextRangeLength(element, text, cursorOffset);
    }

    @NotNull
    protected String getClassAttributeName() {
        if ("class" == null) {
            HtmlSelectioner.$$$reportNull$$$0(7);
        }
        return "class";
    }

    public static void addClassAttributeRanges(@NotNull List<TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @NotNull XmlAttributeValue attributeValue) {
        if (result2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(9);
        }
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(10);
        }
        if (attributeValue == null) {
            HtmlSelectioner.$$$reportNull$$$0(11);
        }
        TextRange attributeValueTextRange = attributeValue.getTextRange();
        LinkedList wordRanges = ContainerUtil.newLinkedList();
        SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, wordRanges, JAVA_IDENTIFIER_AND_HYPHEN_CONDITION);
        for (TextRange range : wordRanges) {
            if (!attributeValueTextRange.contains(range)) continue;
            result2.add(range);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/HtmlSelectioner";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/HtmlSelectioner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAttributeSelection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalTextRangeLength";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addClassAttributeRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

