/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);

    public RunInspectionAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        final PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        final VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                popup2.setSearchInAnyPlace(true);
                return super.createFilter(popup2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project, ((InspectionToolWrapper)element).getShortName(), virtualFile, psiElement, psiFile));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
            }
        }, false);
    }

    public static void runInspection(final @NotNull Project project, @NotNull String shortName, @Nullable VirtualFile virtualFile, PsiElement psiElement, PsiFile psiFile) {
        if (project == null) {
            RunInspectionAction.$$$reportNull$$$0(0);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(1);
        }
        PsiElement element = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element != null ? currentProfile.getInspectionTool(shortName, element) : currentProfile.getInspectionTool(shortName, project);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        final Module module2 = virtualFile != null ? ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project) : null;
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFile != null && virtualFile.isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFile)) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFile != null) {
                analysisScope = new AnalysisScope(project, Arrays.asList(virtualFile));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project);
            }
        }
        final AnalysisUIOptions options = AnalysisUIOptions.getInstance(project);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options);
        final AnalysisScope initialAnalysisScope = analysisScope;
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog("Run '" + toolWrapper.getDisplayName() + "'", AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, analysisScope, module2, true, options, psiElement){
            private InspectionToolWrapper myUpdatedSettingsToolWrapper;

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project2) {
                JPanel fileFilter = fileFilterPanel.getPanel();
                if (toolWrapper.getTool().createOptionsPanel() != null) {
                    JPanel additionPanel = new JPanel();
                    additionPanel.setLayout(new GridBagLayout());
                    additionPanel.add((Component)fileFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    additionPanel.add((Component)new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0])), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, (Insets)JBUI.emptyInsets(), 0, 0));
                    JComponent optionsPanel = this.myUpdatedSettingsToolWrapper.getTool().createOptionsPanel();
                    LOGGER.assertTrue(optionsPanel != null);
                    GridBagConstraints constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0);
                    if (UIUtil.hasScrollPane((Component)optionsPanel)) {
                        additionPanel.add((Component)optionsPanel, constraints);
                    } else {
                        additionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)optionsPanel, (int)0), constraints);
                    }
                    return additionPanel;
                }
                return fileFilter;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project2, Module module22) {
                if (uiOptions == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (defaultScope == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (project2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                AnalysisScope scope = super.getScope(uiOptions, defaultScope, project2, module22);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    2.$$$reportNull$$$0(4);
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(options, initialAnalysisScope, project, module2);
            }

            private InspectionToolWrapper getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            @NotNull
            protected Action[] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? AnalysisScopeBundle.message((String)"action.analyze.verb", (Object[])new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(x0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RunInspectionIntention.rerunInspection(this.getToolWrapper(), managerEx, this.getScope(), null);
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction("Fix All"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper wrapper2 = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper2, managerEx, null);
                            managerEx.createNewGlobalContext(false).codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper2.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[actions.size()]);
                if (actionArray == null) {
                    2.$$$reportNull$$$0(5);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uiOptions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultScope";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getScope";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getScope";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        dialog2.showAndGet();
    }

    private static InspectionToolWrapper copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            RunInspectionAction.$$$reportNull$$$0(2);
        }
        Element options = new Element("copy");
        tool.getTool().writeSettings(options);
        InspectionToolWrapper copiedTool = tool.createCopy();
        copiedTool.getTool().readSettings(options);
        return copiedTool;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToolWithSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

