/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffWindowBase {
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffDialogHints myHints;
    private DiffRequestProcessor myProcessor;
    private WindowWrapper myWrapper;

    public DiffWindowBase(@Nullable Project project, @NotNull DiffDialogHints hints) {
        if (hints == null) {
            DiffWindowBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myHints = hints;
    }

    protected void init() {
        if (this.myWrapper != null) {
            return;
        }
        this.myProcessor = this.createProcessor();
        String dialogGroupKey = (String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY);
        if (dialogGroupKey == null) {
            dialogGroupKey = "DiffContextDialog";
        }
        this.myWrapper = new WindowWrapperBuilder(DiffUtil.getWindowMode(this.myHints), new MyPanel(this.myProcessor.getComponent())).setProject(this.myProject).setParent(this.myHints.getParent()).setDimensionServiceKey(dialogGroupKey).setPreferredFocusedComponent((Computable<JComponent>)((Computable)() -> this.myProcessor.getPreferredFocusedComponent())).setOnShowCallback(() -> this.myProcessor.updateRequest()).build();
        this.myWrapper.setImages(DiffUtil.DIFF_FRAME_ICONS);
        Disposer.register((Disposable)this.myWrapper, (Disposable)this.myProcessor);
    }

    public void show() {
        this.init();
        this.myWrapper.show();
    }

    @NotNull
    protected abstract DiffRequestProcessor createProcessor();

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            DiffWindowBase.$$$reportNull$$$0(1);
        }
        this.myWrapper.setTitle(title);
    }

    protected void onAfterNavigate() {
        DiffUtil.closeWindow(this.myWrapper.getWindow(), true, true);
    }

    protected WindowWrapper getWrapper() {
        return this.myWrapper;
    }

    protected DiffRequestProcessor getProcessor() {
        return this.myProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/impl/DiffWindowBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setWindowTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPanel
    extends JPanel {
        public MyPanel(@NotNull JComponent content) {
            if (content == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)content, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/impl/DiffWindowBase$MyPanel", "<init>"));
        }
    }
}

