/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.DateFormatUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String TAG_EXT = ".etag";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList hosts = ContainerUtil.newArrayList(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        ArrayList arrayList = hosts;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromAllRepositories(@Nullable ProgressIndicator indicator) throws IOException {
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        HashSet<String> addedPluginIds = new HashSet<String>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, indicator);
            for (IdeaPluginDescriptor plugin : plugins2) {
                if (!addedPluginIds.add(plugin.getPluginId().getIdString())) continue;
                result2.add(plugin);
            }
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result2;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadPlugins(null, indicator);
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadPlugins(repositoryUrl, null, indicator);
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber buildnumber, @Nullable ProgressIndicator indicator) throws IOException {
        boolean forceHttps = repositoryUrl == null && IdeaApplication.isLoaded() && UpdateSettings.getInstance().canUseSecureConnection();
        List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadPlugins(repositoryUrl, buildnumber, forceHttps, indicator);
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build, boolean forceHttps, @Nullable ProgressIndicator indicator) throws IOException {
        String url;
        String host;
        String eTag;
        File pluginListFile;
        try {
            URIBuilder uriBuilder;
            if (repositoryUrl == null) {
                uriBuilder = new URIBuilder(ApplicationInfoImpl.getShadowInstance().getPluginsListUrl());
                pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
                eTag = RepositoryHelper.loadPluginListETag(pluginListFile);
            } else {
                uriBuilder = new URIBuilder(repositoryUrl);
                pluginListFile = null;
                eTag = "";
            }
            if (!"file".equals(uriBuilder.getScheme())) {
                uriBuilder.addParameter("build", build != null ? build.asString() : ApplicationInfoImpl.getShadowInstance().getApiVersion());
            }
            host = uriBuilder.getHost();
            url = uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{host}));
        }
        List descriptors = (List)HttpRequests.request((String)url).forceHttps(forceHttps).tuner(connection -> connection.setRequestProperty("If-None-Match", eTag)).productNameAsUserAgent().connect(request -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            URLConnection connection = request.getConnection();
            if (pluginListFile != null && pluginListFile.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                LOG.info("using cached plugin list (updated at " + DateFormatUtil.formatDateTime((long)pluginListFile.lastModified()) + ")");
                return RepositoryHelper.loadPluginList(pluginListFile);
            }
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{host}));
            }
            if (pluginListFile != null) {
                String string = PLUGIN_LIST_FILE;
                synchronized (PLUGIN_LIST_FILE) {
                    FileUtil.ensureExists((File)pluginListFile.getParentFile());
                    request.saveToFile(pluginListFile, indicator);
                    RepositoryHelper.savePluginListETag(pluginListFile, connection.getHeaderField("ETag"));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
            }
            return RepositoryHelper.parsePluginList(request.getReader());
        });
        List<IdeaPluginDescriptor> list2 = RepositoryHelper.process(repositoryUrl, descriptors);
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static String loadPluginListETag(File pluginListFile) {
        File file2 = RepositoryHelper.getPluginListETagFile(pluginListFile);
        if (file2.length() > 0L) {
            try {
                List lines2 = FileUtil.loadLines((File)file2);
                if (lines2.size() == 1) {
                    return (String)lines2.get(0);
                }
                LOG.warn("Can't load plugin list ETag from '" + file2.getAbsolutePath() + "'. Unexpected number of lines: " + lines2.size());
                FileUtil.delete((File)file2);
            }
            catch (IOException e) {
                LOG.warn("Can't load plugin list ETag from '" + file2.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        return "";
    }

    private static void savePluginListETag(File pluginListFile, String eTag) {
        if (eTag != null) {
            File file2 = RepositoryHelper.getPluginListETagFile(pluginListFile);
            try {
                FileUtil.writeToFile((File)file2, (String)eTag);
            }
            catch (IOException e) {
                LOG.warn("Can't save plugin list ETag to '" + file2.getAbsolutePath() + "'", (Throwable)e);
            }
        }
    }

    private static File getPluginListETagFile(File pluginListFile) {
        return new File(pluginListFile.getParentFile(), pluginListFile.getName() + TAG_EXT);
    }

    @Nullable
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() > 0L ? RepositoryHelper.loadPluginList(file2) : null;
    }

    private static List<IdeaPluginDescriptor> loadPluginList(File file2) throws IOException {
        return RepositoryHelper.parsePluginList(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file2)), CharsetToolkit.UTF8_CHARSET));
    }

    private static List<IdeaPluginDescriptor> parsePluginList(Reader reader) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler2 = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler2);
            List<IdeaPluginDescriptor> list2 = handler2.getPluginsList();
            return list2;
        }
        catch (RuntimeException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }

    private static List<IdeaPluginDescriptor> process(String repositoryUrl, List<IdeaPluginDescriptor> list2) {
        Iterator<IdeaPluginDescriptor> i = list2.iterator();
        while (i.hasNext()) {
            PluginNode node = (PluginNode)i.next();
            if (node.getPluginId() == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.warn("Malformed plugin record (id:" + node.getPluginId() + " repository:" + repositoryUrl + ")");
                i.remove();
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() != null) continue;
            String url = node.getDownloadUrl();
            String name = FileUtil.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1));
            node.setName(name);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/RepositoryHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginsFromAllRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPlugins";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

