/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.ide.util.TreeStructureActionsOwner;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FileStructurePopup
implements Disposable,
TreeActionsOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.FileStructurePopup");
    private static final String NARROW_DOWN_PROPERTY_KEY = "FileStructurePopup.narrowDown";
    private final boolean myUseATM;
    private final Project myProject;
    private final FileEditor myFileEditor;
    private final StructureViewModel myTreeModelWrapper;
    private final StructureViewModel myTreeModel;
    private final TreeStructureActionsOwner myTreeActionsOwner;
    private JBPopup myPopup;
    private String myTitle;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final FilteringTreeStructure myFilteringStructure;
    private final FilteringTreeBuilder myTreeBuilder;
    private final AsyncTreeModel myAsyncTreeModel;
    private final StructureTreeModel myStructureTreeModel;
    private final TreeSpeedSearch mySpeedSearch;
    private final Object myInitialElement;
    private final Map<Class, JBCheckBox> myCheckBoxes;
    private final List<JBCheckBox> myAutoClicked;
    private String myTestSearchFilter;
    private final ActionCallback myTreeHasBuilt;
    private boolean myInitialNodeIsLeaf;
    private final List<Pair<String, JBCheckBox>> myTriggeredCheckboxes;
    private final TreeExpander myTreeExpander;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private boolean myCanClose;
    private boolean myDisposed;

    @Deprecated
    public FileStructurePopup(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull StructureView structureView, boolean applySortAndFilter) {
        if (project == null) {
            FileStructurePopup.$$$reportNull$$$0(0);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(1);
        }
        if (structureView == null) {
            FileStructurePopup.$$$reportNull$$$0(2);
        }
        this(project, fileEditor, ViewStructureAction.createStructureViewModel(project, fileEditor, structureView));
        Disposer.register((Disposable)this, (Disposable)structureView);
    }

    public FileStructurePopup(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull StructureViewModel treeModel) {
        if (project == null) {
            FileStructurePopup.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            FileStructurePopup.$$$reportNull$$$0(4);
        }
        if (treeModel == null) {
            FileStructurePopup.$$$reportNull$$$0(5);
        }
        this.myUseATM = Registry.is((String)"structure.view.async.tree.model");
        this.myCheckBoxes = new HashMap<Class, JBCheckBox>();
        this.myAutoClicked = new ArrayList<JBCheckBox>();
        this.myTreeHasBuilt = new ActionCallback();
        this.myTriggeredCheckboxes = new ArrayList<Pair<String, JBCheckBox>>();
        this.myCanClose = true;
        this.myProject = project;
        this.myFileEditor = fileEditor;
        this.myTreeModel = treeModel;
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myTreeHasBuilt, "FileStructurePopup");
        this.myTreeActionsOwner = new TreeStructureActionsOwner(this.myTreeModel);
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this.myTreeActionsOwner);
        this.myTreeStructure = new SmartTreeStructure(project, (TreeModel)this.myTreeModelWrapper){

            @Override
            public void rebuildTree() {
                if (!ApplicationManager.getApplication().isUnitTestMode() && FileStructurePopup.this.myPopup.isDisposed()) {
                    return;
                }
                super.rebuildTree();
                FileStructurePopup.this.myFilteringStructure.rebuild();
            }

            public boolean isToBuildChildrenInBackground(Object element) {
                return this.getRootElement() == element;
            }

            @Override
            protected TreeElementWrapper createTree() {
                return StructureViewComponent.createWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }

            @NonNls
            public String toString() {
                return "structure view tree structure(model=" + FileStructurePopup.this.myTreeModelWrapper + ")";
            }
        };
        FileStructurePopupFilter filter2 = new FileStructurePopupFilter();
        this.myFilteringStructure = new FilteringTreeStructure((ElementFilter)filter2, (AbstractTreeStructure)this.myTreeStructure, false);
        if (this.myUseATM) {
            this.myStructureTreeModel = new StructureTreeModel(true);
            this.myStructureTreeModel.setStructure((AbstractTreeStructure)this.myFilteringStructure);
            this.myAsyncTreeModel = new AsyncTreeModel((javax.swing.tree.TreeModel)((Object)this.myStructureTreeModel));
            this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
            this.myTree = new MyTree((javax.swing.tree.TreeModel)((Object)this.myAsyncTreeModel));
            Disposer.register((Disposable)this, () -> this.myTreeModelWrapper.dispose());
            Disposer.register((Disposable)this, (Disposable)this.myAsyncTreeModel);
            this.myTreeBuilder = null;
        } else {
            this.myStructureTreeModel = null;
            this.myAsyncTreeModel = null;
            this.myTree = new MyTree(new DefaultTreeModel(new DefaultMutableTreeNode(this.myFilteringStructure.getRootElement())));
            this.myTreeBuilder = new FilteringTreeBuilder(this.myTree, filter2, (AbstractTreeStructure)this.myFilteringStructure, null){

                public void initRootNode() {
                }

                protected boolean validateNode(Object child) {
                    Object o = child instanceof FilteringTreeStructure.FilteringNode ? ((FilteringTreeStructure.FilteringNode)child).getDelegate() : child;
                    return !(o instanceof ValidateableNode) || ((ValidateableNode)o).isValid();
                }

                public void revalidateTree() {
                }

                public boolean isToEnsureSelectionOnFocusGained() {
                    return false;
                }
            };
            Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
            this.myTreeBuilder.getUi().getUpdater().setDelay(1);
        }
        final ModelListener modelListener = new ModelListener(){

            public void onModelChanged() {
                FileStructurePopup.this.rebuild(false);
            }
        };
        this.myTreeModel.addModelListener(modelListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                FileStructurePopup.this.myTreeModel.removeModelListener(modelListener);
            }
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            public boolean importData(@NotNull TransferHandler.TransferSupport support) {
                String s;
                if (support == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)) != null && !FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                    FileStructurePopup.this.mySpeedSearch.showPopup(s);
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent component) {
                JBIterable pairs = JBIterable.of((Object[])FileStructurePopup.this.myTree.getSelectionPaths()).filterMap(o -> TreeUtil.getUserObject((Object)o.getLastPathComponent())).filter(FilteringTreeStructure.FilteringNode.class).filterMap(o -> o.getDelegate() instanceof PsiElement ? Pair.create((Object)o, (Object)((PsiElement)o.getDelegate())) : null).collect();
                if (pairs.isEmpty()) {
                    return null;
                }
                Set psiSelection = pairs.map(Functions.pairSecond()).toSet();
                String text = StringUtil.join((Iterable)pairs, pair -> {
                    PsiElement psi = (PsiElement)pair.second;
                    String defaultPresentation = ((FilteringTreeStructure.FilteringNode)pair.first).getPresentation().getPresentableText();
                    if (psi == null) {
                        return defaultPresentation;
                    }
                    for (PsiElement p = psi.getParent(); p != null; p = p.getParent()) {
                        if (!psiSelection.contains(p)) continue;
                        return null;
                    }
                    return (String)ObjectUtils.chooseNotNull((Object)psi.getText(), (Object)defaultPresentation);
                }, (String)"\n");
                String htmlText = "<body>\n" + text + "\n</body>";
                return new TextTransferable(XmlStringUtil.wrapInHtml((CharSequence)htmlText), text);
            }

            @Override
            public int getSourceActions(JComponent component) {
                return 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/ide/util/FileStructurePopup$5", "importData"));
            }
        });
        this.mySpeedSearch = new MyTreeSpeedSearch();
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, true){

            @Override
            @NotNull
            protected MinusculeMatcher createMatcher(@NotNull String pattern) {
                if (pattern == null) {
                    6.$$$reportNull$$$0(0);
                }
                MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).withSeparators(" ()").build();
                if (minusculeMatcher == null) {
                    6.$$$reportNull$$$0(1);
                }
                return minusculeMatcher;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/FileStructurePopup$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/FileStructurePopup$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMatcher";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMatcher";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myCopyPasteDelegator = StructureViewComponent.createCopyPasteDelegator(this.myProject, (JTree)this.myTree);
        this.myInitialElement = this.myTreeModel.getCurrentEditorElement();
        TreeUtil.installActions((JTree)this.myTree);
    }

    public void show() {
        JComponent panel2 = this.createCenterPanel();
        MnemonicHelper.init((Component)panel2);
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(panel2, null).setTitle(this.myTitle).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelKeyEnabled(false).setDimensionServiceKey(null, FileStructurePopup.getDimensionServiceKey(), true).setCancelCallback(() -> this.myCanClose).createPopup();
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PopupUpdateProcessor updateProcessor;
                if (FileStructurePopup.this.myPopup.isVisible() && (updateProcessor = (PopupUpdateProcessor)((Object)FileStructurePopup.this.myPopup.getUserData(PopupUpdateProcessor.class))) != null) {
                    AbstractTreeNode node = FileStructurePopup.this.getSelectedNode();
                    updateProcessor.updatePopup(node);
                }
            }
        });
        Disposer.register((Disposable)this.myPopup, (Disposable)this);
        Disposer.register((Disposable)this.myPopup, (Disposable)new Disposable(){

            public void dispose() {
                if (!FileStructurePopup.this.myTreeHasBuilt.isDone()) {
                    FileStructurePopup.this.myTreeHasBuilt.setRejected();
                }
            }
        });
        this.myTree.getEmptyText().setText("Loading...");
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
        ((AbstractPopup)this.myPopup).setShowHints(true);
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, true);
        Window window = SwingUtilities.windowForComponent(this.myPopup.getContent());
        WindowAdapter windowFocusListener = new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        };
        window.addWindowFocusListener(windowFocusListener);
        Disposer.register((Disposable)this.myPopup, () -> window.removeWindowFocusListener(windowFocusListener));
        this.rebuildAndSelect(false, this.myInitialElement).processed(path -> UIUtil.invokeLaterIfNeeded(() -> {
            TreeUtil.ensureSelection((JTree)this.myTree);
            this.myTreeHasBuilt.setDone();
            this.installUpdater();
        }));
    }

    private void installUpdater() {
        if (ApplicationManager.getApplication().isUnitTestMode() || this.myPopup.isDisposed()) {
            return;
        }
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
        alarm.addRequest(new Runnable(){
            String filter = "";

            @Override
            public void run() {
                alarm.cancelAllRequests();
                String prefix = FileStructurePopup.this.mySpeedSearch.getEnteredPrefix();
                FileStructurePopup.this.myTree.getEmptyText().setText(StringUtil.isEmpty((String)prefix) ? "Structure is empty" : "'" + prefix + "' not found");
                if (prefix == null) {
                    prefix = "";
                }
                if (!this.filter.equals(prefix)) {
                    boolean isBackspace = prefix.length() < this.filter.length();
                    this.filter = prefix;
                    FileStructurePopup.this.rebuild(true).processed(ignore -> UIUtil.invokeLaterIfNeeded(() -> {
                        if (FileStructurePopup.this.isDisposed()) {
                            return;
                        }
                        if (isBackspace && FileStructurePopup.this.handleBackspace(this.filter)) {
                            return;
                        }
                        if (FileStructurePopup.this.myFilteringStructure.getRootElement().getChildren().length == 0) {
                            for (JBCheckBox box : FileStructurePopup.this.myCheckBoxes.values()) {
                                if (box.isSelected()) continue;
                                FileStructurePopup.this.myAutoClicked.add(box);
                                FileStructurePopup.this.myTriggeredCheckboxes.add(0, Pair.create((Object)this.filter, (Object)box));
                                box.doClick();
                                this.filter = "";
                                break;
                            }
                        }
                    }));
                }
                if (!alarm.isDisposed()) {
                    alarm.addRequest((Runnable)this, 300);
                }
            }
        }, 300);
    }

    private boolean handleBackspace(String filter2) {
        Pair<String, JBCheckBox> next;
        boolean clicked = false;
        Iterator<Pair<String, JBCheckBox>> iterator = this.myTriggeredCheckboxes.iterator();
        while (iterator.hasNext() && ((String)(next = iterator.next()).getFirst()).length() >= filter2.length()) {
            if (((String)next.getFirst()).length() < filter2.length()) continue;
            iterator.remove();
            ((JBCheckBox)next.getSecond()).doClick();
            clicked = true;
        }
        return clicked;
    }

    @NotNull
    public Promise<TreePath> select(Object element) {
        if (!this.myUseATM) {
            FilteringTreeStructure.FilteringNode node;
            FilteringTreeStructure.FilteringNode filteringNode = node = element instanceof PsiElement ? this.selectPsiElement((PsiElement)element) : null;
            if (node == null) {
                Promise promise2 = Promises.rejectedPromise();
                if (promise2 == null) {
                    FileStructurePopup.$$$reportNull$$$0(6);
                }
                return promise2;
            }
            Promise promise3 = Promise.resolve((Object)new TreePath(node));
            if (promise3 == null) {
                FileStructurePopup.$$$reportNull$$$0(7);
            }
            return promise3;
        }
        AsyncPromise result2 = new AsyncPromise();
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor2 = path -> {
            Object last = path.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last);
            Object value = StructureViewComponent.unwrapValue(last);
            if (Comparing.equal((Object)value, (Object)element) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value instanceof PsiElement && element instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value), (PsiElement)((PsiElement)element), (boolean)true)) {
                    int count = path.getPathCount();
                    if (stage[1] == 0 || stage[1] < count) {
                        stage[1] = count;
                        deepestPath[0] = path;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function action = path -> {
            Object userObject;
            this.myTree.expandPath(path);
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
            TreeUtil.ensureSelection((JTree)this.myTree);
            Object object = userObject = path == null ? null : TreeUtil.getUserObject((Object)path.getLastPathComponent());
            if (userObject != null && Comparing.equal((Object)element, (Object)StructureViewComponent.unwrapValue(userObject))) {
                this.myInitialNodeIsLeaf = this.myFilteringStructure.getChildElements(userObject).length == 0;
            }
            return Promises.resolvedPromise((Object)path);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            public Promise<TreePath> fun(TreePath path) {
                if (path == null && stage[0] == 2) {
                    stage[0] = 3;
                    return FileStructurePopup.this.myAsyncTreeModel.accept(visitor2).thenAsync((Function)this);
                }
                TreePath adjusted = path == null ? deepestPath[0] : path;
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action.fun((Object)adjusted);
            }
        };
        this.myStructureTreeModel.getInvoker().invokeLaterIfNeeded(() -> this.lambda$select$7(visitor2, (Function)fallback, result2));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileStructurePopup.$$$reportNull$$$0(8);
        }
        return asyncPromise;
    }

    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        if (!this.myUseATM) {
            this.rebuild(false).notify(result2);
            return result2;
        }
        TreeVisitor visitor2 = path -> {
            Object o = TreeUtil.getUserObject((Object)path.getLastPathComponent());
            if (o instanceof AbstractTreeNode) {
                ((AbstractTreeNode)o).update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.rebuild(false).processed(ignore1 -> this.myStructureTreeModel.getInvoker().invokeLater(() -> this.myAsyncTreeModel.accept(visitor2).processed(ignore2 -> result2.setResult(null))));
        return result2;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private static boolean isShouldNarrowDown() {
        return PropertiesComponent.getInstance().getBoolean(NARROW_DOWN_PROPERTY_KEY, true);
    }

    @NonNls
    protected static String getDimensionServiceKey() {
        return "StructurePopup";
    }

    @Nullable
    public PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModelWrapper.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        if (psiFile != null && this.myFileEditor instanceof TextEditor) {
            return psiFile.getViewProvider().findElementAt(((TextEditor)this.myFileEditor).getEditor().getCaretModel().getOffset());
        }
        return null;
    }

    public JComponent createCenterPanel() {
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        ArrayList<FileStructureNodeProvider> fileStructureNodeProviders = new ArrayList<FileStructureNodeProvider>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter2 : this.myTreeModel.getFilters()) {
                if (!(filter2 instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter2;
                this.myTreeActionsOwner.setActionIncluded((TreeAction)fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
            if (this.myTreeModel instanceof ProvidingTreeModel) {
                for (NodeProvider provider : ((ProvidingTreeModel)this.myTreeModel).getNodeProviders()) {
                    if (!(provider instanceof FileStructureNodeProvider)) continue;
                    fileStructureNodeProviders.add((FileStructureNodeProvider)provider);
                }
            }
        }
        int checkBoxCount = fileStructureNodeProviders.size() + fileStructureFilters.size();
        final JPanel panel2 = new JPanel(new BorderLayout());
        JPanel chkPanel = new JPanel(new GridLayout(0, checkBoxCount > 0 && checkBoxCount % 4 == 0 ? checkBoxCount / 2 : 3, 0, 0));
        Object[] F4 = ActionManager.getInstance().getAction("EditSource").getShortcutSet().getShortcuts();
        Object[] ENTER = CustomShortcutSet.fromString((String[])new String[]{"ENTER"}).getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet((Shortcut[])ArrayUtil.mergeArrays((Object[])F4, (Object[])ENTER));
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                boolean succeeded = FileStructurePopup.this.navigateSelectedElement();
                if (succeeded) {
                    this.unregisterCustomShortcutSet(panel2);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)panel2);
        DumbAwareAction.create(e -> {
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.mySpeedSearch.hidePopup();
            } else {
                this.myPopup.cancel();
            }
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this.myTree);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                TreePath path;
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                if ((path = FileStructurePopup.this.myTree.getPathForLocation(e.getX(), e.getY())) == null) {
                    return false;
                }
                FileStructurePopup.this.navigateSelectedElement();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/FileStructurePopup$13", "onClick"));
            }
        }.installOn((Component)this.myTree);
        for (FileStructureFilter filter3 : fileStructureFilters) {
            this.addCheckbox(chkPanel, (TreeAction)filter3);
        }
        for (FileStructureNodeProvider provider : fileStructureNodeProviders) {
            this.addCheckbox(chkPanel, (TreeAction)provider);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)chkPanel, "West");
        topPanel.add((Component)this.createSettingsButton(), "East");
        panel2.add((Component)topPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)10));
        Dimension preferredSize = scrollPane.getPreferredSize();
        preferredSize.width = Math.max(chkPanel.getPreferredSize().width, JBUI.scale((int)350));
        scrollPane.setPreferredSize(preferredSize);
        panel2.add((Component)scrollPane, "Center");
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return FileStructurePopup.this.myProject;
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return FileStructurePopup.this.myFileEditor;
                }
                if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && FileStructurePopup.this.myFileEditor instanceof TextEditor) {
                    return ((TextEditor)FileStructurePopup.this.myFileEditor).getEditor();
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    return FileStructurePopup.this.getSelectedElements().filter(PsiElement.class).first();
                }
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return PsiUtilCore.toPsiElementArray((Collection)FileStructurePopup.this.getSelectedElements().filter(PsiElement.class).toList());
                }
                if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                    return FileStructurePopup.this.getSelectedElements().filter(Navigatable.class).first();
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    List result2 = FileStructurePopup.this.getSelectedElements().filter(Navigatable.class).toList();
                    return result2.isEmpty() ? null : result2.toArray(new Navigatable[result2.size()]);
                }
                if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                    return FileStructurePopup.this.myPopup;
                }
                if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                    return FileStructurePopup.this.myCopyPasteDelegator.getCopyProvider();
                }
                if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                    return FileStructurePopup.this.myTreeExpander;
                }
                return null;
            }
        });
        panel2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileStructurePopup.this.myPopup.cancel();
            }
        });
        return panel2;
    }

    @NotNull
    private JBIterable<Object> getSelectedElements() {
        JBIterable jBIterable = JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent()));
        if (jBIterable == null) {
            FileStructurePopup.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    protected JComponent createSettingsButton() {
        final JLabel label = new JLabel(AllIcons.General.SecondaryGroup);
        label.setHorizontalAlignment(4);
        label.setVerticalAlignment(1);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    16.$$$reportNull$$$0(0);
                }
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new ToggleAction(IdeBundle.message((String)"checkbox.narrow.down.on.typing", (Object[])new Object[0])){

                    public boolean isSelected(AnActionEvent e) {
                        return FileStructurePopup.isShouldNarrowDown();
                    }

                    public void setSelected(AnActionEvent e, boolean state2) {
                        PropertiesComponent.getInstance().setValue(FileStructurePopup.NARROW_DOWN_PROPERTY_KEY, Boolean.toString(state2));
                        if (FileStructurePopup.this.mySpeedSearch.isPopupActive() && !StringUtil.isEmpty((String)FileStructurePopup.this.mySpeedSearch.getEnteredPrefix())) {
                            FileStructurePopup.this.rebuild(true);
                        }
                    }
                });
                DataManager dataManager = DataManager.getInstance();
                ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataManager.getDataContext((Component)label), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                popup2.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        FileStructurePopup.this.myCanClose = true;
                    }
                });
                FileStructurePopup.this.myCanClose = false;
                popup2.showUnderneathOf((Component)label);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/FileStructurePopup$16", "onClick"));
            }
        }.installOn((Component)label);
        JLabel jLabel = label;
        if (jLabel == null) {
            FileStructurePopup.$$$reportNull$$$0(10);
        }
        return jLabel;
    }

    @Nullable
    private AbstractTreeNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        Object o = StructureViewComponent.unwrapNavigatable(path == null ? null : path.getLastPathComponent());
        return o instanceof AbstractTreeNode ? (AbstractTreeNode)o : null;
    }

    public boolean navigateSelectedElement() {
        AbstractTreeNode selectedNode = this.getSelectedNode();
        if (ApplicationManager.getApplication().isInternal()) {
            String enteredPrefix = this.mySpeedSearch.getEnteredPrefix();
            String itemText = FileStructurePopup.getSpeedSearchText(selectedNode);
            if (StringUtil.isNotEmpty((String)enteredPrefix) && StringUtil.isNotEmpty((String)itemText)) {
                LOG.info("Chosen in file structure popup by prefix '" + enteredPrefix + "': '" + itemText + "'");
            }
        }
        Ref succeeded = new Ref();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            if (selectedNode != null) {
                if (selectedNode.canNavigateToSource()) {
                    selectedNode.navigate(true);
                    this.myPopup.cancel();
                    succeeded.set((Object)true);
                } else {
                    succeeded.set((Object)false);
                }
            } else {
                succeeded.set((Object)false);
            }
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        }, "Navigate", null);
        return (Boolean)succeeded.get();
    }

    private void addCheckbox(JPanel panel2, final TreeAction action) {
        String text;
        String string = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getCheckBoxText() : (text = action instanceof FileStructureNodeProvider ? ((FileStructureNodeProvider)action).getCheckBoxText() : null);
        if (text == null) {
            return;
        }
        Shortcut[] shortcuts = FileStructurePopup.extractShortcutFor(action);
        final JBCheckBox checkBox = new JBCheckBox();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)checkBox);
        boolean selected = FileStructurePopup.getDefaultValue(action);
        checkBox.setSelected(selected);
        final boolean isRevertedStructureFilter = action instanceof FileStructureFilter && ((FileStructureFilter)action).isReverted();
        this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter != selected);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state2 = checkBox.isSelected();
                if (!FileStructurePopup.this.myAutoClicked.contains(checkBox)) {
                    FileStructurePopup.saveState(action, state2);
                }
                FileStructurePopup.this.myTreeActionsOwner.setActionIncluded(action, isRevertedStructureFilter != state2);
                FileStructurePopup.this.rebuild(action instanceof FileStructureFilter).processed(ignore -> {
                    if (FileStructurePopup.this.mySpeedSearch.isPopupActive()) {
                        FileStructurePopup.this.mySpeedSearch.refreshSelection();
                    }
                });
            }
        });
        checkBox.setFocusable(false);
        if (shortcuts.length > 0) {
            text = text + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            DumbAwareAction.create(e -> checkBox.doClick()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myTree);
        }
        checkBox.setText(StringUtil.capitalize((String)StringUtil.trimStart((String)text.trim(), (String)"Show ")));
        panel2.add((Component)checkBox);
        this.myCheckBoxes.put(action.getClass(), checkBox);
    }

    @NotNull
    private Promise<Void> rebuild(boolean refilterOnly) {
        Object selection = JBIterable.of((Object[])this.myTree.getSelectionPaths()).filterMap(o -> StructureViewComponent.unwrapValue(o.getLastPathComponent())).first();
        Promise promise2 = this.rebuildAndSelect(refilterOnly, selection).then(o -> null);
        if (promise2 == null) {
            FileStructurePopup.$$$reportNull$$$0(11);
        }
        return promise2;
    }

    @NotNull
    private Promise<TreePath> rebuildAndSelect(boolean refilterOnly, Object selection) {
        AsyncPromise result2 = new AsyncPromise();
        if (!this.myUseATM) {
            if (!refilterOnly) {
                this.myTreeStructure.rebuildTree();
            }
            this.myTreeBuilder.refilter(selection, true, false).doWhenProcessed(() -> {
                if (selection instanceof PsiElement) {
                    this.selectPsiElement((PsiElement)selection);
                }
                result2.setResult(null);
            });
            AsyncPromise asyncPromise = result2;
            if (asyncPromise == null) {
                FileStructurePopup.$$$reportNull$$$0(12);
            }
            return asyncPromise;
        }
        this.myStructureTreeModel.getInvoker().invokeLaterIfNeeded(() -> {
            if (refilterOnly) {
                this.myFilteringStructure.refilter();
                this.myStructureTreeModel.invalidate().rejected(ignore -> result2.setError("rejected")).done(ignore -> (selection == null ? this.myAsyncTreeModel.accept(o -> TreeVisitor.Action.CONTINUE) : this.select(selection)).rejected(ignore2 -> result2.setError("rejected")).done(p -> UIUtil.invokeLaterIfNeeded(() -> {
                    TreeUtil.expand((JTree)this.getTree(), (int)2);
                    TreeUtil.ensureSelection((JTree)this.myTree);
                    this.mySpeedSearch.refreshSelection();
                    result2.setResult(p);
                })));
            } else {
                this.myTreeStructure.rebuildTree();
                this.myStructureTreeModel.invalidate().rejected(ignore -> result2.setError("rejected")).done(ignore -> this.rebuildAndSelect(true, selection).notify(result2));
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            FileStructurePopup.$$$reportNull$$$0(13);
        }
        return asyncPromise;
    }

    @NotNull
    static Shortcut[] extractShortcutFor(@NotNull TreeAction action) {
        if (action == null) {
            FileStructurePopup.$$$reportNull$$$0(14);
        }
        if (action instanceof ActionShortcutProvider) {
            String actionId = ((ActionShortcutProvider)action).getActionIdForShortcut();
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts();
            if (shortcutArray == null) {
                FileStructurePopup.$$$reportNull$$$0(15);
            }
            return shortcutArray;
        }
        Shortcut[] shortcutArray = action instanceof FileStructureFilter ? ((FileStructureFilter)action).getShortcut() : ((FileStructureNodeProvider)action).getShortcut();
        if (shortcutArray == null) {
            FileStructurePopup.$$$reportNull$$$0(16);
        }
        return shortcutArray;
    }

    private static boolean getDefaultValue(TreeAction action) {
        if (action instanceof PropertyOwner) {
            String propertyName = ((PropertyOwner)action).getPropertyName();
            return PropertiesComponent.getInstance().getBoolean(TreeStructureUtil.getPropertyName(propertyName));
        }
        return false;
    }

    private static void saveState(TreeAction action, boolean state2) {
        if (action instanceof PropertyOwner) {
            String propertyName = ((PropertyOwner)action).getPropertyName();
            PropertiesComponent.getInstance().setValue(TreeStructureUtil.getPropertyName(propertyName), state2);
        }
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            FileStructurePopup.$$$reportNull$$$0(17);
        }
        return tree;
    }

    public TreeSpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    public void setSearchFilterForTests(String filter2) {
        this.myTestSearchFilter = filter2;
    }

    public void setTreeActionState(Class<? extends TreeAction> action, boolean state2) {
        JBCheckBox checkBox = this.myCheckBoxes.get(action);
        if (checkBox != null) {
            checkBox.setSelected(state2);
            for (ActionListener listener2 : checkBox.getActionListeners()) {
                listener2.actionPerformed(new ActionEvent(this, 1, ""));
            }
        }
    }

    @Nullable
    public static String getSpeedSearchText(Object object) {
        String text = String.valueOf(object);
        Object value = StructureViewComponent.unwrapWrapper(object);
        if (text != null) {
            String locationString;
            if (value instanceof PsiTreeElementBase && ((PsiTreeElementBase)value).isSearchInLocationString() && !StringUtil.isEmpty((String)(locationString = ((PsiTreeElementBase)value).getLocationString()))) {
                String locationPrefix = null;
                String locationSuffix = null;
                if (value instanceof LocationPresentation) {
                    locationPrefix = ((LocationPresentation)value).getLocationPrefix();
                    locationSuffix = ((LocationPresentation)value).getLocationSuffix();
                }
                return text + StringUtil.notNullize((String)locationPrefix, (String)" (") + locationString + StringUtil.notNullize((String)locationSuffix, (String)")");
            }
            return text;
        }
        if (value instanceof TreeElement) {
            return (String)ReadAction.compute(() -> ((TreeElement)value).getPresentation().getPresentableText());
        }
        return null;
    }

    @Override
    public void setActionActive(String name, boolean state2) {
    }

    @Override
    public boolean isActionActive(String name) {
        return false;
    }

    @Nullable
    private String getSearchPrefix() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myTestSearchFilter;
        }
        return this.mySpeedSearch != null && !StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix()) ? this.mySpeedSearch.getEnteredPrefix() : null;
    }

    @Nullable
    private Object findClosestTo(Object path, List<SpeedSearchObjectWithWeight> paths) {
        if (path == null || !(this.myInitialElement instanceof PsiElement)) {
            return paths.get((int)0).node;
        }
        Set<PsiElement> parents = FileStructurePopup.getAllParents((PsiElement)this.myInitialElement);
        ArrayList<SpeedSearchObjectWithWeight> cur = new ArrayList<SpeedSearchObjectWithWeight>();
        int max = -1;
        for (SpeedSearchObjectWithWeight p : paths) {
            FilteringTreeStructure.FilteringNode node;
            Object object = TreeUtil.getUserObject((Object)((TreePath)p.node).getLastPathComponent());
            if (!(object instanceof FilteringTreeStructure.FilteringNode)) continue;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            FilteringTreeStructure.FilteringNode candidate = node = (FilteringTreeStructure.FilteringNode)object;
            while (node != null) {
                elements.add(FileStructurePopup.getPsi(node));
                node = node.getParentNode();
            }
            int size = ContainerUtil.intersection(parents, elements).size();
            if (size == elements.size() - 1 && size == parents.size() - (this.myInitialNodeIsLeaf ? 1 : 0) && candidate.children().isEmpty()) {
                return p.node;
            }
            if (size > max) {
                max = size;
                cur.clear();
                cur.add(p);
                continue;
            }
            if (size != max) continue;
            cur.add(p);
        }
        Collections.sort(cur, (o1, o2) -> {
            int i = o1.compareWith((SpeedSearchObjectWithWeight)o2);
            return i != 0 ? i : ((TreePath)o2.node).getPathCount() - ((TreePath)o1.node).getPathCount();
        });
        return cur.isEmpty() ? null : ((SpeedSearchObjectWithWeight)cur.get((int)0)).node;
    }

    @Nullable
    private static PsiElement getPsi(FilteringTreeStructure.FilteringNode n) {
        return (PsiElement)ObjectUtils.tryCast((Object)StructureViewComponent.unwrapValue(n), PsiElement.class);
    }

    @Nullable
    public FilteringTreeStructure.FilteringNode selectPsiElement(PsiElement element) {
        Set<PsiElement> parents = FileStructurePopup.getAllParents(element);
        FilteringTreeStructure.FilteringNode node = (FilteringTreeStructure.FilteringNode)this.myTreeBuilder.getRootElement();
        if (element != null && node != null && this.myTreeModel instanceof StructureViewCompositeModel) {
            parents.remove(element.getContainingFile());
            List fileNodes = node.children();
            for (FilteringTreeStructure.FilteringNode fileNode : fileNodes) {
                FilteringTreeStructure.FilteringNode found = this.findNode(parents, fileNode);
                if (found == null || found == fileNode) continue;
                return found;
            }
        } else {
            FilteringTreeStructure.FilteringNode found = this.findNode(parents, node);
            if (found == null) {
                TreeUtil.ensureSelection((JTree)this.myTree);
            }
            return found;
        }
        TreeUtil.ensureSelection((JTree)this.myTree);
        return null;
    }

    private FilteringTreeStructure.FilteringNode findNode(Set<PsiElement> parents, FilteringTreeStructure.FilteringNode node) {
        while (node != null) {
            boolean changed = false;
            for (FilteringTreeStructure.FilteringNode n : node.children()) {
                PsiElement psiElement = FileStructurePopup.getPsi(n);
                if (psiElement == null || !parents.contains(psiElement)) continue;
                node = n;
                changed = true;
                break;
            }
            if (changed) continue;
            this.myTreeBuilder.select((Object)node);
            if (this.myTreeBuilder.getSelectedElements().isEmpty()) {
                TreeUtil.selectFirstNode((JTree)this.myTree);
            }
            this.myInitialNodeIsLeaf = node.getChildren().length == 0;
            return node;
        }
        return null;
    }

    private static Set<PsiElement> getAllParents(PsiElement element) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        while (element != null) {
            parents.add(element);
            if (element instanceof PsiFile) break;
            element = element.getParent();
        }
        return parents;
    }

    private /* synthetic */ void lambda$select$7(TreeVisitor visitor2, Function fallback, AsyncPromise result2) {
        this.myAsyncTreeModel.accept(visitor2).thenAsync(fallback).processed(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/FileStructurePopup";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsButton";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuild";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildAndSelect";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractShortcutFor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractShortcutFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyTree
    extends DnDAwareTree
    implements PlaceProvider<String> {
        MyTree(javax.swing.tree.TreeModel treeModel) {
            super(treeModel);
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setHorizontalAutoScrollingEnabled(false);
            HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), o -> {
                Object value = StructureViewComponent.unwrapValue(o);
                return value instanceof PsiElement ? (PsiElement)value : null;
            });
        }

        public String getPlace() {
            return "StructureViewPopup";
        }
    }

    private class MyTreeSpeedSearch
    extends TreeSpeedSearch {
        MyTreeSpeedSearch() {
            super(FileStructurePopup.this.myTree, (Convertor<TreePath, String>)((Convertor)path -> FileStructurePopup.getSpeedSearchText(TreeUtil.getUserObject((Object)path.getLastPathComponent()))), true);
        }

        @Override
        protected Point getComponentLocationOnScreen() {
            return FileStructurePopup.this.myPopup.getContent().getLocationOnScreen();
        }

        @Override
        protected Rectangle getComponentVisibleRect() {
            return FileStructurePopup.this.myPopup.getContent().getVisibleRect();
        }

        @Override
        public Object findElement(String s) {
            List<SpeedSearchObjectWithWeight> elements = SpeedSearchObjectWithWeight.findElement(s, this);
            return elements.isEmpty() ? null : FileStructurePopup.this.findClosestTo(FileStructurePopup.this.myInitialElement, elements);
        }
    }

    private class FileStructurePopupFilter
    implements ElementFilter {
        private String myLastFilter = null;
        private final Set<Object> myVisibleParents = new com.intellij.util.containers.HashSet();
        private final boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();

        private FileStructurePopupFilter() {
        }

        public boolean shouldBeShowing(Object value) {
            if (!FileStructurePopup.isShouldNarrowDown()) {
                return true;
            }
            String filter2 = FileStructurePopup.this.getSearchPrefix();
            if (!StringUtil.equals((CharSequence)this.myLastFilter, (CharSequence)filter2)) {
                this.myVisibleParents.clear();
                this.myLastFilter = filter2;
            }
            if (filter2 != null) {
                if (this.myVisibleParents.contains(value)) {
                    return true;
                }
                String text = FileStructurePopup.getSpeedSearchText(value);
                if (text == null) {
                    return false;
                }
                if (this.matches(text)) {
                    Object o = value;
                    while (o instanceof FilteringTreeStructure.FilteringNode && (o = ((FilteringTreeStructure.FilteringNode)o).getParent()) != null) {
                        this.myVisibleParents.add(o);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        private boolean matches(@NotNull String text) {
            if (text == null) {
                FileStructurePopupFilter.$$$reportNull$$$0(0);
            }
            if (this.isUnitTest) {
                SpeedSearchComparator comparator2 = FileStructurePopup.this.mySpeedSearch.getComparator();
                return StringUtil.isNotEmpty((String)FileStructurePopup.this.myTestSearchFilter) && comparator2.matchingFragments(FileStructurePopup.this.myTestSearchFilter, text) != null;
            }
            return FileStructurePopup.this.mySpeedSearch.matchingFragments(text) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/FileStructurePopup$FileStructurePopupFilter", "matches"));
        }
    }
}

