/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewCompositeModel
extends StructureViewModelBase
implements Disposable {
    private final StructureViewComposite.StructureViewDescriptor[] myViews;

    public StructureViewCompositeModel(PsiFile file2, StructureViewComposite.StructureViewDescriptor[] views) {
        super(file2, StructureViewCompositeModel.createRootNode(file2, views));
        this.myViews = views;
    }

    private static StructureViewTreeElement createRootNode(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor[] views) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return file2;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = file2.getPresentation();
                if (itemPresentation == null) {
                    1.$$$reportNull$$$0(0);
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                ArrayList<TreeElement> elements = new ArrayList<TreeElement>();
                for (StructureViewComposite.StructureViewDescriptor view : views) {
                    elements.add(StructureViewCompositeModel.createTreeElementFromView(file2, view));
                }
                TreeElement[] treeElementArray = elements.toArray(new TreeElement[elements.size()]);
                if (treeElementArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return treeElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/util/StructureViewCompositeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        HashSet<NodeProvider> providers = new HashSet<NodeProvider>();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            if (!(model instanceof ProvidingTreeModel)) continue;
            providers.addAll(((ProvidingTreeModel)model).getNodeProviders());
        }
        HashSet<NodeProvider> hashSet = providers;
        if (hashSet == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    public Filter[] getFilters() {
        HashSet filters = new HashSet();
        for (StructureViewComposite.StructureViewDescriptor view : this.myViews) {
            StructureViewModel model = view.structureView.getTreeModel();
            ContainerUtil.addAll(filters, (Object[])model.getFilters());
        }
        Filter[] filterArray = filters.toArray(new Filter[filters.size()]);
        if (filterArray == null) {
            StructureViewCompositeModel.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    private static TreeElement createTreeElementFromView(final PsiFile file2, final StructureViewComposite.StructureViewDescriptor view) {
        return new StructureViewTreeElement(){

            public Object getValue() {
                return view;
            }

            public void navigate(boolean requestFocus) {
                file2.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return file2.canNavigate();
            }

            public boolean canNavigateToSource() {
                return file2.canNavigateToSource();
            }

            @NotNull
            public ItemPresentation getPresentation() {
                ItemPresentation itemPresentation = new ItemPresentation(){

                    @Nullable
                    public String getPresentableText() {
                        return view.title;
                    }

                    @Nullable
                    public String getLocationString() {
                        return null;
                    }

                    @Nullable
                    public Icon getIcon(boolean unused) {
                        return view.icon;
                    }
                };
                if (itemPresentation == null) {
                    2.$$$reportNull$$$0(0);
                }
                return itemPresentation;
            }

            @NotNull
            public TreeElement[] getChildren() {
                TreeElement[] treeElementArray = view.structureView.getTreeModel().getRoot().getChildren();
                if (treeElementArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return treeElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/util/StructureViewCompositeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/StructureViewCompositeModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

