/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.customUsageCollectors.actions.MainMenuCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PoppedIcon;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.JBCheckBoxMenuItem;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.ui.plaf.gtk.GtkMenuItemUI;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.synth.SynthMenuItemUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionMenuItem
extends JBCheckBoxMenuItem {
    private static final Icon ourCheckedIcon = JBUI.scale((JBUI.JBIcon)new SizedIcon(PlatformIcons.CHECK_ICON, 18, 18));
    private static final Icon ourUncheckedIcon = EmptyIcon.ICON_18;
    private final ActionRef<AnAction> myAction;
    private final Presentation myPresentation;
    private final String myPlace;
    private final boolean myInsideCheckedGroup;
    private final boolean myEnableMnemonics;
    private final boolean myToggleable;
    private DataContext myContext;
    private AnActionEvent myEvent;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private boolean myToggled;

    public ActionMenuItem(AnAction action, Presentation presentation, @NotNull String place, @NotNull DataContext context, boolean enableMnemonics, boolean prepareNow, boolean insideCheckedGroup) {
        if (place == null) {
            ActionMenuItem.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionMenuItem.$$$reportNull$$$0(1);
        }
        this.myAction = ActionRef.fromAction(action);
        this.myPresentation = presentation;
        this.myPlace = place;
        this.myContext = context;
        this.myEnableMnemonics = enableMnemonics;
        this.myToggleable = action instanceof Toggleable;
        this.myInsideCheckedGroup = insideCheckedGroup;
        this.myEvent = new AnActionEvent(null, context, place, this.myPresentation, ActionManager.getInstance(), 0, true, false);
        this.addActionListener(new ActionTransmitter());
        this.setBorderPainted(false);
        this.updateUI();
        if (prepareNow) {
            this.init();
        } else {
            this.setText("loading...");
        }
    }

    public AnAction getAnAction() {
        return this.myAction.getAction();
    }

    public String getPlace() {
        return this.myPlace;
    }

    private static boolean isEnterKeyStroke(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() == 10 && keyStroke.getModifiers() == 0;
    }

    public void prepare() {
        this.init();
        this.installSynchronizer();
    }

    public void fireActionPerformed(ActionEvent event) {
        AnAction action = this.myAction.getAction();
        if (action != null && "MainMenu".equals(this.myPlace)) {
            MainMenuCollector.getInstance().record(action);
        }
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> super.fireActionPerformed(event));
    }

    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
        this.init();
    }

    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            Disposer.dispose((Disposable)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    private void init() {
        int mnemonicIndex;
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setMnemonic(this.myEnableMnemonics ? this.myPresentation.getMnemonic() : 0);
        this.setText(this.myPresentation.getText());
        int n = mnemonicIndex = this.myEnableMnemonics ? this.myPresentation.getDisplayedMnemonicIndex() : -1;
        if (this.getText() != null && mnemonicIndex >= 0 && mnemonicIndex < this.getText().length()) {
            this.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        AnAction action = this.myAction.getAction();
        this.updateIcon(action);
        String id = ActionManager.getInstance().getId(action);
        if (id != null) {
            this.setAcceleratorFromShortcuts(KeymapUtil.getActiveKeymapShortcuts((String)id).getShortcuts());
        } else {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet != null) {
                this.setAcceleratorFromShortcuts(shortcutSet.getShortcuts());
            }
        }
    }

    private void setAcceleratorFromShortcuts(@NotNull Shortcut[] shortcuts) {
        if (shortcuts == null) {
            ActionMenuItem.$$$reportNull$$$0(2);
        }
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyStroke firstKeyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            if (ActionMenuItem.isEnterKeyStroke(firstKeyStroke)) break;
            this.setAccelerator(firstKeyStroke);
            break;
        }
    }

    public void updateUI() {
        if (UIUtil.isStandardMenuLAF()) {
            super.updateUI();
        } else {
            this.setUI(BegMenuItemUI.createUI((JComponent)((Object)this)));
        }
    }

    public void setUI(MenuItemUI ui) {
        MenuItemUI newUi = UIUtil.isUnderGTKLookAndFeel() && ui instanceof SynthMenuItemUI ? new GtkMenuItemUI((SynthMenuItemUI)ui) : ui;
        super.setUI(newUi);
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.myPresentation.getDescription());
    }

    public String getFirstShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction.getAction());
    }

    public void updateContext(@NotNull DataContext context) {
        if (context == null) {
            ActionMenuItem.$$$reportNull$$$0(3);
        }
        this.myContext = context;
        this.myEvent = new AnActionEvent(null, context, this.myPlace, this.myPresentation, ActionManager.getInstance(), 0, true, false);
    }

    private void updateIcon(AnAction action) {
        if (this.isToggleable() && (this.myPresentation.getIcon() == null || this.myInsideCheckedGroup || !UISettings.getInstance().getShowIconsInMenus())) {
            action.update(this.myEvent);
            this.myToggled = Boolean.TRUE.equals(this.myEvent.getPresentation().getClientProperty("selected"));
            if ("MainMenu".equals(this.myPlace) && SystemInfo.isMacSystemMenu || UIUtil.isUnderNimbusLookAndFeel() || UIUtil.isUnderWindowsLookAndFeel() && SystemInfo.isWin7OrNewer) {
                this.setState(this.myToggled);
            } else if (!(this.getUI() instanceof GtkMenuItemUI)) {
                if (this.myToggled) {
                    this.setIcon(ourCheckedIcon);
                    this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)ourCheckedIcon));
                } else {
                    this.setIcon(ourUncheckedIcon);
                    this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)ourUncheckedIcon));
                }
            }
        } else if (UISettings.getInstance().getShowIconsInMenus()) {
            Icon icon = this.myPresentation.getIcon();
            if (action instanceof ToggleAction && ((ToggleAction)action).isSelected(this.myEvent)) {
                icon = new PoppedIcon(icon, 16, 16);
            }
            this.setIcon(icon);
            if (this.myPresentation.getDisabledIcon() != null) {
                this.setDisabledIcon(this.myPresentation.getDisabledIcon());
            } else {
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            }
        }
    }

    public void setIcon(Icon icon) {
        if (SystemInfo.isMacSystemMenu && "MainMenu".equals(this.myPlace)) {
            icon = IconLoader.get1xIcon((Icon)icon);
        }
        super.setIcon(icon);
    }

    public boolean isToggleable() {
        return this.myToggleable;
    }

    public boolean isSelected() {
        return this.myToggled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionMenuItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAcceleratorFromShortcuts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MenuItemSynchronizer
    implements PropertyChangeListener,
    Disposable {
        @NonNls
        private static final String SELECTED = "selected";
        private final Set<String> mySynchronized = new HashSet<String>();

        private MenuItemSynchronizer() {
            ActionMenuItem.this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void dispose() {
            ActionMenuItem.this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean queueForDispose = ActionMenuItem.this.getParent() == null;
            String name = e.getPropertyName();
            if (this.mySynchronized.contains(name)) {
                return;
            }
            this.mySynchronized.add(name);
            try {
                if ("visible".equals(name)) {
                    boolean visible = ActionMenuItem.this.myPresentation.isVisible();
                    if (!visible && SystemInfo.isMacSystemMenu && ActionMenuItem.this.myPlace.equals("MainMenu")) {
                        ActionMenuItem.this.setEnabled(false);
                    } else {
                        ActionMenuItem.this.setVisible(visible);
                    }
                } else if ("enabled".equals(name)) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.myPresentation.isEnabled());
                    ActionMenuItem.this.updateIcon(ActionMenuItem.this.myAction.getAction());
                } else if ("mnemonicKey".equals(name)) {
                    ActionMenuItem.this.setMnemonic(ActionMenuItem.this.myPresentation.getMnemonic());
                } else if ("mnemonicIndex".equals(name)) {
                    ActionMenuItem.this.setDisplayedMnemonicIndex(ActionMenuItem.this.myPresentation.getDisplayedMnemonicIndex());
                } else if ("text".equals(name)) {
                    ActionMenuItem.this.setText(ActionMenuItem.this.myPresentation.getText());
                } else if ("icon".equals(name) || "disabledIcon".equals(name) || SELECTED.equals(name)) {
                    ActionMenuItem.this.updateIcon(ActionMenuItem.this.myAction.getAction());
                }
            }
            finally {
                this.mySynchronized.remove(name);
                if (queueForDispose) {
                    SwingUtilities.invokeLater(() -> {
                        if (ActionMenuItem.this.getParent() == null) {
                            ActionMenuItem.this.uninstallSynchronizer();
                        }
                    });
                }
            }
        }
    }

    private final class ActionTransmitter
    implements ActionListener {
        private ActionTransmitter() {
        }

        private boolean isInTree(Component component) {
            if (component instanceof Window) {
                return component.isShowing();
            }
            Window windowAncestor = SwingUtilities.getWindowAncestor(component);
            return windowAncestor != null && windowAncestor.isShowing();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IdeFocusManager fm = IdeFocusManager.findInstanceByContext((DataContext)ActionMenuItem.this.myContext);
            ActionCallback typeAhead = new ActionCallback();
            String id = ActionManager.getInstance().getId(ActionMenuItem.this.myAction.getAction());
            if (id != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("context.menu.click.stats." + id.replace(' ', '.'));
            }
            fm.typeAheadUntil(typeAhead, ActionMenuItem.this.getText());
            fm.runOnOwnContext(ActionMenuItem.this.myContext, () -> {
                AnActionEvent event = new AnActionEvent((InputEvent)new MouseEvent((Component)((Object)ActionMenuItem.this), 501, 0L, e.getModifiers(), ActionMenuItem.this.getWidth() / 2, ActionMenuItem.this.getHeight() / 2, 1, false), ActionMenuItem.this.myContext, ActionMenuItem.this.myPlace, ActionMenuItem.this.myPresentation, ActionManager.getInstance(), e.getModifiers(), true, false);
                Object menuItemAction = ActionMenuItem.this.myAction.getAction();
                if (ActionUtil.lastUpdateAndCheckDumb(menuItemAction, (AnActionEvent)event, (boolean)false)) {
                    ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                    actionManager.fireBeforeActionPerformed(menuItemAction, ActionMenuItem.this.myContext, event);
                    fm.doWhenFocusSettlesDown(() -> ((ActionCallback)typeAhead).setDone());
                    ActionUtil.performActionDumbAware(menuItemAction, (AnActionEvent)event);
                    actionManager.queueActionPerformedEvent(menuItemAction, ActionMenuItem.this.myContext, event);
                } else {
                    typeAhead.setDone();
                }
            });
        }
    }
}

