/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyRangeMarkerFactoryImpl
extends LazyRangeMarkerFactory {
    private final Project myProject;
    private static final Key<WeakList<LazyMarker>> LAZY_MARKERS_KEY = Key.create((String)"LAZY_MARKERS_KEY");

    public LazyRangeMarkerFactoryImpl(@NotNull Project project, final @NotNull FileDocumentManager fileDocumentManager) {
        if (project == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(0);
        }
        if (fileDocumentManager == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent e) {
                this.transformRangeMarkers(e);
            }

            public void documentChanged(DocumentEvent e) {
                this.transformRangeMarkers(e);
            }

            private void transformRangeMarkers(@NotNull DocumentEvent e) {
                Document document;
                VirtualFile file2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file2 = fileDocumentManager.getFile(document = e.getDocument())) == null || LazyRangeMarkerFactoryImpl.this.myProject.isDisposed()) {
                    return;
                }
                WeakList<LazyMarker> lazyMarkers = LazyRangeMarkerFactoryImpl.getMarkers(file2);
                if (lazyMarkers == null) {
                    return;
                }
                List markers = lazyMarkers.toStrongList();
                for (LazyMarker marker : markers) {
                    if (!file2.equals(marker.getFile())) continue;
                    marker.getOrCreateDelegate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$1", "transformRangeMarkers"));
            }
        }, (Disposable)project);
    }

    static WeakList<LazyMarker> getMarkers(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(2);
        }
        return (WeakList)file2.getUserData(LAZY_MARKERS_KEY);
    }

    private static void addToLazyMarkersList(@NotNull LazyMarker marker, @NotNull VirtualFile file2) {
        Object markers;
        if (marker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(4);
        }
        if ((markers = LazyRangeMarkerFactoryImpl.getMarkers(file2)) == null) {
            markers = (Collection)file2.putUserDataIfAbsent(LAZY_MARKERS_KEY, (Object)new WeakList());
        }
        markers.add(marker);
    }

    private static void removeFromLazyMarkersList(@NotNull LazyMarker marker, @NotNull VirtualFile file2) {
        WeakList<LazyMarker> markers;
        if (marker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(6);
        }
        if ((markers = LazyRangeMarkerFactoryImpl.getMarkers(file2)) != null) {
            markers.remove((Object)marker);
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int offset) {
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(7);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> {
            if (file2 == null) {
                LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(13);
            }
            OffsetLazyMarker marker = new OffsetLazyMarker(file2, offset);
            LazyRangeMarkerFactoryImpl.addToLazyMarkersList(marker, file2);
            return marker;
        });
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(8);
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int line, int column, boolean persistent) {
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(9);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> {
            Document document;
            if (file2 == null) {
                LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(12);
            }
            if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
                int myTabSize = CodeStyleFacade.getInstance((Project)this.myProject).getTabSize(file2.getFileType());
                int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document, line, column, myTabSize);
                return document.createRangeMarker(offset, offset, persistent);
            }
            LineColumnLazyMarker marker = new LineColumnLazyMarker(this.myProject, file2, line, column);
            LazyRangeMarkerFactoryImpl.addToLazyMarkersList(marker, file2);
            return marker;
        });
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(10);
        }
        return rangeMarker;
    }

    private static int calculateOffset(@NotNull Document document, int line, int column, int tabSize) {
        int offset;
        if (document == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(11);
        }
        if (0 <= line && line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMarkers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToLazyMarkersList";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFromLazyMarkersList";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRangeMarker$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRangeMarker$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineColumnLazyMarker
    extends LazyMarker {
        private final int myLine;
        private final int myColumn;
        private final int myTabSize;

        private LineColumnLazyMarker(@NotNull Project project, @NotNull VirtualFile file2, int line, int column) {
            if (project == null) {
                LineColumnLazyMarker.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                LineColumnLazyMarker.$$$reportNull$$$0(1);
            }
            super(file2, -1);
            this.myLine = line;
            this.myColumn = column;
            this.myTabSize = CodeStyleFacade.getInstance((Project)project).getTabSize(file2.getFileType());
        }

        @Override
        @Nullable
        public RangeMarker createDelegate(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                LineColumnLazyMarker.$$$reportNull$$$0(2);
            }
            if (document == null) {
                LineColumnLazyMarker.$$$reportNull$$$0(3);
            }
            if (document.getTextLength() == 0 && (this.myLine != 0 || this.myColumn != 0)) {
                return null;
            }
            int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document, this.myLine, this.myColumn, this.myTabSize);
            return document.createRangeMarker(offset, offset);
        }

        @Override
        public boolean isValid() {
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
                return document != null && (document.getTextLength() != 0 || this.myLine == 0 && this.myColumn == 0);
            }
            return super.isValid();
        }

        @Override
        public int getStartOffset() {
            this.getOrCreateDelegate();
            return super.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            this.getOrCreateDelegate();
            return super.getEndOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LineColumnLazyMarker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createDelegate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OffsetLazyMarker
    extends LazyMarker {
        private OffsetLazyMarker(@NotNull VirtualFile file2, int offset) {
            if (file2 == null) {
                OffsetLazyMarker.$$$reportNull$$$0(0);
            }
            super(file2, offset);
        }

        @Override
        public boolean isValid() {
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
                return document != null;
            }
            return super.isValid();
        }

        @Override
        @NotNull
        public RangeMarker createDelegate(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                OffsetLazyMarker.$$$reportNull$$$0(1);
            }
            if (document == null) {
                OffsetLazyMarker.$$$reportNull$$$0(2);
            }
            int offset = Math.min(this.myInitialOffset, document.getTextLength());
            RangeMarker rangeMarker = document.createRangeMarker(offset, offset);
            if (rangeMarker == null) {
                OffsetLazyMarker.$$$reportNull$$$0(3);
            }
            return rangeMarker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createDelegate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class LazyMarker
    extends UserDataHolderBase
    implements RangeMarker {
        protected RangeMarker myDelegate;
        protected final VirtualFile myFile;
        protected final int myInitialOffset;

        private LazyMarker(@NotNull VirtualFile file2, int offset) {
            if (file2 == null) {
                LazyMarker.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
            this.myInitialOffset = offset;
        }

        boolean isDelegated() {
            return this.myDelegate != null;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                LazyMarker.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @Nullable
        final RangeMarker getOrCreateDelegate() {
            if (this.myDelegate == null) {
                Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
                if (document == null) {
                    return null;
                }
                this.myDelegate = this.createDelegate(this.myFile, document);
                LazyRangeMarkerFactoryImpl.removeFromLazyMarkersList(this, this.myFile);
            }
            return this.isDisposed() ? null : this.myDelegate;
        }

        @Nullable
        protected abstract RangeMarker createDelegate(@NotNull VirtualFile var1, @NotNull Document var2);

        @NotNull
        public Document getDocument() {
            RangeMarker delegate = this.getOrCreateDelegate();
            if (delegate == null) {
                Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
                if (document == null) {
                    LazyMarker.$$$reportNull$$$0(2);
                }
                return document;
            }
            Document document = delegate.getDocument();
            if (document == null) {
                LazyMarker.$$$reportNull$$$0(3);
            }
            return document;
        }

        public int getStartOffset() {
            return this.myDelegate == null || this.isDisposed() ? this.myInitialOffset : this.myDelegate.getStartOffset();
        }

        public boolean isDisposed() {
            return this.myDelegate == this;
        }

        public int getEndOffset() {
            return this.myDelegate == null || this.isDisposed() ? this.myInitialOffset : this.myDelegate.getEndOffset();
        }

        public boolean isValid() {
            RangeMarker delegate = this.getOrCreateDelegate();
            return delegate != null && !this.isDisposed() && delegate.isValid();
        }

        public void setGreedyToLeft(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToLeft(greedy);
        }

        public void setGreedyToRight(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToRight(greedy);
        }

        public boolean isGreedyToRight() {
            return this.getOrCreateDelegate().isGreedyToRight();
        }

        public boolean isGreedyToLeft() {
            return this.getOrCreateDelegate().isGreedyToLeft();
        }

        public void dispose() {
            assert (!this.isDisposed());
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                LazyRangeMarkerFactoryImpl.removeFromLazyMarkersList(this, this.myFile);
                this.myDelegate = this;
            } else {
                delegate.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

