/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.util.Computable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWithTimeoutInDispatch
extends AbstractProgressIndicatorExBase
implements PingProgress {
    private final long myTimeoutMs;
    private final long myStartTimeMs;

    private ProgressWithTimeoutInDispatch(long timeoutMs) {
        this.myTimeoutMs = timeoutMs;
        this.myStartTimeMs = System.currentTimeMillis();
        this.setIndeterminate(true);
    }

    @Override
    public boolean isCanceled() {
        if (System.currentTimeMillis() - this.myStartTimeMs >= this.myTimeoutMs) {
            this.cancel();
        }
        return super.isCanceled();
    }

    @Override
    public void interact() {
    }

    @ApiStatus.Experimental
    @Nullable
    public static <T> T execInDispatchWithTimeout(@NotNull Computable<T> action, long timeoutMs) throws ProcessCanceledException {
        Application application;
        if (action == null) {
            ProgressWithTimeoutInDispatch.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread() && timeoutMs > 0L && ProgressManager.getInstance().getProgressIndicator() == null) {
            try {
                return (T)ProgressManager.getInstance().runProcess(action, (ProgressIndicator)new ProgressWithTimeoutInDispatch(timeoutMs));
            }
            catch (ProcessCanceledException ex) {
                return null;
            }
        }
        return (T)action.compute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressWithTimeoutInDispatch", "execInDispatchWithTimeout"));
    }
}

