/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DelayedNotificator
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.DelayedNotificator");
    private final EventDispatcher<ChangeListListener> myDispatcher;
    private final ChangeListManagerImpl.Scheduler myScheduler;

    public DelayedNotificator(@NotNull EventDispatcher<ChangeListListener> dispatcher, @NotNull ChangeListManagerImpl.Scheduler scheduler) {
        if (dispatcher == null) {
            DelayedNotificator.$$$reportNull$$$0(0);
        }
        if (scheduler == null) {
            DelayedNotificator.$$$reportNull$$$0(1);
        }
        this.myDispatcher = dispatcher;
        this.myScheduler = scheduler;
    }

    public void callNotify(ChangeListCommand command) {
        this.myScheduler.submit(() -> {
            try {
                command.doNotify(this.myDispatcher);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        });
    }

    public void changeListAdded(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListAdded(list2));
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesRemoved(changes, fromList));
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesAdded(changes, toList));
    }

    public void changeListRemoved(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListRemoved(list2));
    }

    public void changeListChanged(ChangeList list2) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListChanged(list2));
    }

    public void changeListRenamed(ChangeList list2, String oldName) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListRenamed(list2, oldName));
    }

    public void changeListCommentChanged(ChangeList list2, String oldComment) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListCommentChanged(list2, oldComment));
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changesMoved(changes, fromList, toList));
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).defaultListChanged(oldDefaultList, newDefaultList));
    }

    public void unchangedFileStatusChanged() {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).unchangedFileStatusChanged());
    }

    public void changeListUpdateDone() {
        this.myScheduler.submit(() -> ((ChangeListListener)this.myDispatcher.getMulticaster()).changeListUpdateDone());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dispatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scheduler";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/DelayedNotificator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

