/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.processor.GenProcessor;
import com.intellij.psi.codeStyle.extractor.ui.CodeStyleSettingsNameProvider;
import com.intellij.psi.codeStyle.extractor.ui.ExtractedSettingsDialog;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.BalloonLayout;
import java.awt.Frame;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class ExtractCodeStyleAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file2 = null;
        if (editor == null && files != null && files.length == 1 && !files[0].isDirectory()) {
            file2 = PsiManager.getInstance((Project)project).findFile(files[0]);
        } else if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (file2 == null) {
            return;
        }
        Language language = file2.getLanguage();
        LangCodeStyleExtractor extractor = (LangCodeStyleExtractor)LangCodeStyleExtractor.EXTENSION.forLanguage(language);
        if (extractor == null) {
            return;
        }
        final CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        GenProcessor genProcessor = new GenProcessor(extractor);
        PsiFile finalFile = file2;
        Task.Backgroundable task2 = new Task.Backgroundable(project, "Code style extractor", true, (CodeStyleDeriveProcessor)genProcessor, finalFile, project){
            final /* synthetic */ CodeStyleDeriveProcessor val$genProcessor;
            final /* synthetic */ PsiFile val$finalFile;
            final /* synthetic */ Project val$project;
            {
                this.val$genProcessor = codeStyleDeriveProcessor;
                this.val$finalFile = psiFile;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CodeStyleSettings cloneSettings = settings.clone();
                    Map backup = this.val$genProcessor.backupValues(cloneSettings, this.val$finalFile.getLanguage());
                    ValuesExtractionResult res = this.val$genProcessor.runWithProgress(this.val$project, cloneSettings, this.val$finalFile, indicator);
                    ExtractCodeStyleAction.this.reportResult(res, this.val$project, cloneSettings, this.val$finalFile, backup);
                }
                catch (ProcessCanceledException e) {
                    Utils.logError((String)"Code extraction was canceled");
                }
                catch (Throwable t) {
                    Utils.logError((String)("Unexpected exception:\n" + t));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/codeStyle/extractor/ExtractCodeStyleAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    public void reportResult(final ValuesExtractionResult forSelection, final Project project, final CodeStyleSettings cloneSettings, final PsiFile file2, final Map<Value, Object> backup) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Formatting Options were extracted<br/><a href=\"apply\">Apply</a> <a href=\"details\">Details...</a>", MessageType.INFO, new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    boolean apply2 = "apply".equals(e.getDescription());
                    ExtractedSettingsDialog myDialog = null;
                    if (!apply2) {
                        List values = forSelection.getValues();
                        LanguageCodeStyleSettingsProvider[] providers = (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)LanguageCodeStyleSettingsProvider.EP_NAME);
                        Language language = file2.getLanguage();
                        CodeStyleSettingsNameProvider nameProvider = new CodeStyleSettingsNameProvider();
                        for (LanguageCodeStyleSettingsProvider provider : providers) {
                            Language target2 = provider.getLanguage();
                            if (!target2.equals(language)) continue;
                            nameProvider.addSettings(provider);
                            myDialog = new ExtractedSettingsDialog(project, nameProvider, values);
                            apply2 = myDialog.showAndGet();
                            break;
                        }
                    }
                    if (apply2 && myDialog != null) {
                        ExtractedSettingsDialog finalMyDialog = myDialog;
                        forSelection.applyConditioned(value -> finalMyDialog.valueIsSelectedInTree((Value)value), backup);
                        CodeStyleScheme derivedScheme = CodeStyleSchemes.getInstance().createNewScheme("Derived from " + file2.getName(), null);
                        derivedScheme.getCodeStyleSettings().copyFrom(cloneSettings);
                        CodeStyleSchemes.getInstance().addScheme(derivedScheme);
                        CodeStyleSchemesImpl.getSchemeManager().setCurrent(derivedScheme);
                        CodeStyleSettingsManager.getInstance((Project)project).PREFERRED_PROJECT_CODE_STYLE = derivedScheme.getName();
                    }
                }
            }
        }).setDisposable((Disposable)ApplicationManager.getApplication()).setShowCallout(false).setFadeoutTime(0L).setShowCallout(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnKeyOutside(false).setCloseButtonEnabled(true).setHideOnLinkClick(true).createBalloon();
        ApplicationManager.getApplication().invokeLater(() -> {
            BalloonLayout layout;
            Frame window = WindowManager.getInstance().getFrame(project);
            if (window == null) {
                window = JOptionPane.getRootFrame();
            }
            if (window instanceof IdeFrame && (layout = ((IdeFrame)window).getBalloonLayout()) != null) {
                layout.add(balloon);
            }
        });
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = null;
        if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        } else {
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (files != null && files.length == 1 && !files[0].isDirectory()) {
                file2 = PsiManager.getInstance((Project)project).findFile(files[0]);
            }
        }
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            presentation.setEnabled(true);
        }
    }
}

