/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;

public abstract class AbstractSyntheticBlock
implements Block {
    protected final Indent myIndent;
    protected final XmlFormattingPolicy myXmlFormattingPolicy;
    protected final ASTNode myEndTreeNode;
    protected final ASTNode myStartTreeNode;
    private final XmlTag myTag;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.AbstractSyntheticBlock");

    public AbstractSyntheticBlock(List<Block> subBlocks, Block parent, XmlFormattingPolicy policy, Indent indent) {
        this.myEndTreeNode = this.getLastNode(subBlocks);
        this.myStartTreeNode = this.getFirstNode(subBlocks);
        this.myIndent = indent;
        this.myXmlFormattingPolicy = policy;
        if (parent instanceof AbstractXmlBlock) {
            this.myTag = ((AbstractXmlBlock)parent).getTag();
        } else if (parent instanceof AbstractSyntheticBlock) {
            this.myTag = ((AbstractSyntheticBlock)parent).getTag();
        } else {
            throw new IllegalStateException("Parent should be AbstractXmlBlock or AbstractSyntheticBlock, but it is " + parent.getClass());
        }
    }

    public boolean shouldKeepWhiteSpacesInside() {
        return this.myTag != null && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.myTag);
    }

    private ASTNode getFirstNode(List<Block> subBlocks) {
        LOG.assertTrue(!subBlocks.isEmpty());
        Block firstBlock = subBlocks.get(0);
        if (firstBlock instanceof AbstractBlock) {
            return ((AbstractBlock)firstBlock).getNode();
        }
        return this.getFirstNode(firstBlock.getSubBlocks());
    }

    private ASTNode getLastNode(List<Block> subBlocks) {
        LOG.assertTrue(!subBlocks.isEmpty());
        Block lastBlock = subBlocks.get(subBlocks.size() - 1);
        if (lastBlock instanceof AbstractBlock) {
            return ((AbstractBlock)lastBlock).getNode();
        }
        return this.getLastNode(lastBlock.getSubBlocks());
    }

    private boolean isEndOfTag() {
        return this.myEndTreeNode.getElementType() == XmlTokenType.XML_TAG_END;
    }

    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return null;
    }

    protected static boolean isXmlTagName(IElementType type1, IElementType type2) {
        if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && type2 == XmlTokenType.XML_TAG_END) {
            return true;
        }
        if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        if (type1 == XmlElementType.XML_ATTRIBUTE && type2 == XmlTokenType.XML_EMPTY_ELEMENT_END) {
            return true;
        }
        return type1 == XmlElementType.XML_ATTRIBUTE && type2 == XmlTokenType.XML_TAG_END;
    }

    public boolean endsWithText() {
        return this.myEndTreeNode.getElementType() == XmlElementType.XML_TEXT || this.myEndTreeNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myEndTreeNode.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF || this.myEndTreeNode.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    public boolean isTagDescription() {
        ASTNode startTreeNode = this.myStartTreeNode;
        return AbstractSyntheticBlock.isTagDescription(startTreeNode);
    }

    private static boolean isTagDescription(ASTNode startTreeNode) {
        return startTreeNode.getElementType() == XmlTokenType.XML_START_TAG_START || startTreeNode.getElementType() == XmlTokenType.XML_END_TAG_START;
    }

    public boolean startsWithText() {
        return this.myStartTreeNode.getElementType() == XmlElementType.XML_TEXT || this.myStartTreeNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myStartTreeNode.getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF || this.myStartTreeNode.getElementType() == XmlElementType.XML_ENTITY_REF;
    }

    public boolean endsWithTextElement() {
        if (this.endsWithText()) {
            return true;
        }
        if (this.isEndOfTag() && this.myXmlFormattingPolicy.isTextElement(this.getTag())) {
            return true;
        }
        return this.isTextTag(this.myEndTreeNode);
    }

    protected XmlTag getTag() {
        return this.myTag;
    }

    public boolean startsWithTextElement() {
        if (this.startsWithText()) {
            return true;
        }
        if (this.isStartOfTag() && this.myXmlFormattingPolicy.isTextElement(this.getTag())) {
            return true;
        }
        return this.isTextTag(this.myStartTreeNode);
    }

    private boolean isTextTag(ASTNode treeNode) {
        return this.isXmlTag(treeNode) && this.myXmlFormattingPolicy.isTextElement((XmlTag)SourceTreeToPsiMap.treeElementToPsi(treeNode));
    }

    private boolean isXmlTag(ASTNode treeNode) {
        return treeNode.getPsi() instanceof XmlTag;
    }

    private boolean isStartOfTag() {
        return AbstractSyntheticBlock.isTagDescription(this.myStartTreeNode);
    }

    protected static TextRange calculateTextRange(List<Block> subBlocks) {
        return new TextRange(subBlocks.get(0).getTextRange().getStartOffset(), subBlocks.get(subBlocks.size() - 1).getTextRange().getEndOffset());
    }

    public boolean isIncomplete() {
        return ((Block)this.getSubBlocks().get(this.getSubBlocks().size() - 1)).isIncomplete();
    }

    public boolean startsWithTag() {
        return this.isXmlTag(this.myStartTreeNode);
    }

    public XmlTag getStartTag() {
        return (XmlTag)this.myStartTreeNode.getPsi();
    }

    public boolean endsWithTag() {
        return this.isXmlTag(this.myEndTreeNode);
    }

    public boolean isJspTextBlock() {
        return false;
    }

    public boolean isJspxTextBlock() {
        return false;
    }

    public boolean isOuterLanguageBlock() {
        return this.myStartTreeNode == this.myEndTreeNode && this.myStartTreeNode instanceof OuterLanguageElement;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean startsWithCDATA() {
        return this.isCDATA(this.myStartTreeNode.getFirstChildNode());
    }

    private boolean isCDATA(ASTNode node) {
        return node != null && node.getElementType() == XmlElementType.XML_CDATA;
    }

    public boolean containsCDATA() {
        return this.myStartTreeNode.getElementType() == XmlTokenType.XML_CDATA_START && this.myEndTreeNode.getElementType() == XmlTokenType.XML_CDATA_END;
    }

    public boolean endsWithCDATA() {
        return this.isCDATA(this.myStartTreeNode.getLastChildNode());
    }

    public boolean insertLineFeedAfter() {
        List subBlocks = this.getSubBlocks();
        Block lastBlock = (Block)subBlocks.get(subBlocks.size() - 1);
        if (lastBlock instanceof XmlTagBlock) {
            return this.insertLineFeedAfter(((XmlTagBlock)lastBlock).getTag());
        }
        if (this.endsWithText()) {
            return this.insertLineFeedAfter(this.myTag);
        }
        return false;
    }

    protected boolean insertLineFeedAfter(XmlTag tag) {
        return this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag) == WrapType.ALWAYS;
    }
}

