/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ServersToolWindowManager {
    @NotNull
    private final Project myProject;
    private final String myWindowId;
    private final Icon myIcon;

    public ServersToolWindowManager(@NotNull Project project, String windowId, Icon icon) {
        if (project == null) {
            ServersToolWindowManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myWindowId = windowId;
        this.myIcon = icon;
        StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> this.setupListeners());
    }

    public void setupListeners() {
        this.getFactory().getContribution().setupAvailabilityListener(this.myProject, () -> this.updateWindowAvailable(true));
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    1.$$$reportNull$$$0(0);
                }
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    1.$$$reportNull$$$0(1);
                }
                ServersToolWindowManager.this.updateWindowAvailable(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "server";
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateWindowAvailable(boolean showIfAvailable) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            boolean available = this.getFactory().getContribution().canContribute(this.myProject);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(this.myWindowId);
            if (toolWindow == null) {
                if (available) {
                    this.createToolWindow(this.myProject, toolWindowManager).show(null);
                }
                return;
            }
            this.doUpdateWindowAvailable(toolWindow, showIfAvailable, available);
        });
    }

    protected void doUpdateWindowAvailable(@NotNull ToolWindow toolWindow, boolean showIfAvailable, boolean available) {
        boolean doShow;
        if (toolWindow == null) {
            ServersToolWindowManager.$$$reportNull$$$0(1);
        }
        boolean bl = doShow = !toolWindow.isAvailable() && available;
        if (toolWindow.isAvailable() && !available) {
            toolWindow.hide(null);
        }
        toolWindow.setAvailable(available, null);
        if (showIfAvailable && doShow) {
            toolWindow.show(null);
        }
    }

    protected ToolWindow createToolWindow(Project project, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.myWindowId, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(this.myIcon);
        this.getFactory().createToolWindowContent(project, toolWindow);
        return toolWindow;
    }

    @NotNull
    protected abstract ServersToolWindowFactory getFactory();

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ServersToolWindowManager.$$$reportNull$$$0(2);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateWindowAvailable";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

