/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorTextFieldCellRenderer
implements TableCellRenderer,
Disposable {
    private static final Key<SimpleRendererComponent> MY_PANEL_PROPERTY = Key.create((String)"EditorTextFieldCellRenderer.MyEditorPanel");
    private final Project myProject;
    private final FileType myFileType;
    private final boolean myInheritFontFromLaF;

    protected EditorTextFieldCellRenderer(@Nullable Project project, @Nullable FileType fileType, @NotNull Disposable parent) {
        if (parent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(0);
        }
        this(project, fileType, true, parent);
    }

    protected EditorTextFieldCellRenderer(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF, @NotNull Disposable parent) {
        if (parent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileType = fileType;
        this.myInheritFontFromLaF = inheritFontFromLaF;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected abstract String getText(JTable var1, Object var2, int var3, int var4);

    @Nullable
    protected TextAttributes getTextAttributes(JTable table, Object value, int row, int column) {
        return null;
    }

    @NotNull
    protected EditorColorsScheme getColorScheme(JTable table) {
        EditorColorsScheme editorColorsScheme = this.getEditorPanel(table).getEditor().getColorsScheme();
        if (editorColorsScheme == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(2);
        }
        return editorColorsScheme;
    }

    protected void customizeEditor(@NotNull EditorEx editor, JTable table, Object value, boolean selected, int row, int column) {
        if (editor == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(3);
        }
        String text = this.getText(table, value, row, column);
        this.getEditorPanel(table).setText(text, this.getTextAttributes(table, value, row, column), selected);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        RendererComponent panel2 = this.getEditorPanel(table);
        EditorEx editor = panel2.getEditor();
        editor.getColorsScheme().setEditorFontSize(table.getFont().getSize());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, table.getSelectionBackground());
        editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, table.getSelectionForeground());
        editor.setBackgroundColor(selected ? table.getSelectionBackground() : table.getBackground());
        panel2.setSelected(!Comparing.equal((Object)editor.getBackgroundColor(), (Object)table.getBackground()));
        panel2.setBorder(null);
        this.customizeEditor(editor, table, value, selected, row, column);
        return panel2;
    }

    @NotNull
    private RendererComponent getEditorPanel(final JTable table) {
        RendererComponent panel2 = (RendererComponent)UIUtil.getClientProperty((Object)table, MY_PANEL_PROPERTY);
        if (panel2 != null) {
            DelegateColorScheme scheme2 = (DelegateColorScheme)panel2.getEditor().getColorsScheme();
            scheme2.setDelegate(EditorColorsManager.getInstance().getGlobalScheme());
            RendererComponent rendererComponent = panel2;
            if (rendererComponent == null) {
                EditorTextFieldCellRenderer.$$$reportNull$$$0(4);
            }
            return rendererComponent;
        }
        panel2 = this.createRendererComponent(this.myProject, this.myFileType, this.myInheritFontFromLaF);
        Disposer.register((Disposable)this, (Disposable)panel2);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                UIUtil.putClientProperty((JComponent)table, (Key)MY_PANEL_PROPERTY, null);
            }
        });
        table.putClientProperty(MY_PANEL_PROPERTY, panel2);
        RendererComponent rendererComponent = panel2;
        if (rendererComponent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(5);
        }
        return rendererComponent;
    }

    @NotNull
    protected RendererComponent createRendererComponent(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
        AbbreviatingRendererComponent abbreviatingRendererComponent = new AbbreviatingRendererComponent(project, fileType, inheritFontFromLaF);
        if (abbreviatingRendererComponent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(6);
        }
        return abbreviatingRendererComponent;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorTextFieldCellRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorTextFieldCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRendererComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDocument
    extends UserDataHolderBase
    implements DocumentEx {
        RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree<RangeMarkerEx>((Document)this){};
        char[] myChars = ArrayUtil.EMPTY_CHAR_ARRAY;
        String myString = "";
        LineSet myLineSet = LineSet.createLineSet(this.myString);

        private MyDocument() {
        }

        @Override
        public void setModificationStamp(long modificationStamp) {
        }

        @Override
        public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
            if (chars == null) {
                MyDocument.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveText(int srcStart, int srcEnd, int dstOffset) {
            throw new UnsupportedOperationException();
        }

        public void setText(@NotNull CharSequence text) {
            if (text == null) {
                MyDocument.$$$reportNull$$$0(1);
            }
            String s = StringUtil.convertLineSeparators((String)text.toString());
            this.myChars = new char[s.length()];
            s.getChars(0, s.length(), this.myChars, 0);
            this.myString = new String(this.myChars);
            this.myLineSet = LineSet.createLineSet(this.myString);
        }

        @Override
        @NotNull
        public LineIterator createLineIterator() {
            LineIterator lineIterator = this.myLineSet.createIterator();
            if (lineIterator == null) {
                MyDocument.$$$reportNull$$$0(2);
            }
            return lineIterator;
        }

        @Override
        public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
            if (rangeMarker == null) {
                MyDocument.$$$reportNull$$$0(3);
            }
            return this.myRangeMarkers.removeInterval(rangeMarker);
        }

        @Override
        public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
            if (rangeMarker == null) {
                MyDocument.$$$reportNull$$$0(4);
            }
            this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, false, layer);
        }

        @Override
        public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
            if (processor2 == null) {
                MyDocument.$$$reportNull$$$0(5);
            }
            return this.myRangeMarkers.processAll((Processor)processor2);
        }

        @Override
        public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
            if (processor2 == null) {
                MyDocument.$$$reportNull$$$0(6);
            }
            return this.myRangeMarkers.processOverlappingWith(start, end, (Processor)processor2);
        }

        @NotNull
        public CharSequence getImmutableCharSequence() {
            String string = this.myString;
            if (string == null) {
                MyDocument.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public char[] getChars() {
            if (this.myChars == null) {
                MyDocument.$$$reportNull$$$0(8);
            }
            return this.myChars;
        }

        public int getLineCount() {
            return this.myLineSet.findLineIndex(this.myChars.length) + 1;
        }

        public int getLineNumber(int offset) {
            return this.myLineSet.findLineIndex(offset);
        }

        public int getLineStartOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineStart(line);
        }

        public int getLineEndOffset(int line) {
            return this.myChars.length == 0 ? 0 : this.myLineSet.getLineEnd(line);
        }

        public void insertString(int offset, @NotNull CharSequence s) {
            if (s == null) {
                MyDocument.$$$reportNull$$$0(9);
            }
            throw new UnsupportedOperationException("Not implemented");
        }

        public void deleteString(int startOffset, int endOffset) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
            if (s == null) {
                MyDocument.$$$reportNull$$$0(10);
            }
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean isWritable() {
            return false;
        }

        public long getModificationStamp() {
            return 0L;
        }

        @NotNull
        public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @NotNull
        public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
            throw new UnsupportedOperationException("Not implemented");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarker";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorTextFieldCellRenderer$MyDocument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLineIterator";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableCharSequence";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChars";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceText";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRangeMarker";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "registerRangeMarker";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processRangeMarkers";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processRangeMarkersOverlappingWith";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "insertString";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AbbreviatingRendererComponent
    extends RendererComponent {
        private static final char ABBREVIATION_SUFFIX = '\u2026';
        private static final char RETURN_SYMBOL = '\u23ce';
        private final StringBuilder myDocumentTextBuilder = new StringBuilder();
        private Dimension myPreferredSize;
        private String myRawText;

        public AbbreviatingRendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.myRawText = text;
            this.myPreferredSize = null;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myPreferredSize == null) {
                int maxLineLength = 0;
                int linesCount = 0;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                while (!lt.atEnd()) {
                    maxLineLength = Math.max(maxLineLength, lt.getLength());
                    ++linesCount;
                    lt.advance();
                }
                FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
                int preferredHeight = this.getEditor().getLineHeight() * Math.max(1, linesCount);
                int preferredWidth = fontMetrics.charWidth('m') * maxLineLength;
                Insets insets = this.getInsets();
                if (insets != null) {
                    preferredHeight += insets.top + insets.bottom;
                    preferredWidth += insets.left + insets.right;
                }
                this.myPreferredSize = new Dimension(preferredWidth, preferredHeight);
            }
            return this.myPreferredSize;
        }

        @Override
        protected void paintChildren(Graphics g) {
            this.updateText(g.getClipBounds());
            super.paintChildren(g);
        }

        private void updateText(Rectangle clip) {
            boolean singleLineMode;
            FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
            Insets insets = this.getInsets();
            int maxLineWidth = this.getWidth() - (insets != null ? insets.left + insets.right : 0);
            this.myDocumentTextBuilder.setLength(0);
            boolean bl = singleLineMode = (float)this.getHeight() / (float)this.getEditor().getLineHeight() < 1.1f;
            if (singleLineMode) {
                AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, 0, this.myRawText.length(), fontMetrics, maxLineWidth, true);
            } else {
                int line;
                int lineHeight = this.getEditor().getLineHeight();
                int firstVisibleLine = clip.y / lineHeight;
                float visibleLinesCountFractional = (float)clip.height / (float)lineHeight;
                int linesToAppend = 1 + (int)visibleLinesCountFractional;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                for (line = 0; !lt.atEnd() && line < firstVisibleLine; ++line) {
                    this.myDocumentTextBuilder.append('\n');
                    lt.advance();
                }
                for (line = 0; !lt.atEnd() && line < linesToAppend; ++line) {
                    int start = lt.getOffset();
                    int end = start + lt.getLength();
                    AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, start, end, fontMetrics, maxLineWidth, false);
                    if (lt.getLineSeparatorLength() > 0) {
                        this.myDocumentTextBuilder.append('\n');
                    }
                    lt.advance();
                }
            }
            this.setTextToEditor(this.myDocumentTextBuilder.toString());
        }

        private static void appendAbbreviated(StringBuilder to, String text, int start, int end, FontMetrics metrics, int maxWidth, boolean replaceLineTerminators) {
            int abbreviationLength = AbbreviatingRendererComponent.abbreviationLength(text, start, end, metrics, maxWidth, replaceLineTerminators);
            if (!replaceLineTerminators) {
                to.append(text, start, start + abbreviationLength);
            } else {
                CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start, start + abbreviationLength);
                LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
                while (!lt.atEnd()) {
                    to.append((CharSequence)subSeq, lt.getOffset(), lt.getOffset() + lt.getLength());
                    if (lt.getLineSeparatorLength() > 0) {
                        to.append('\u23ce');
                    }
                    lt.advance();
                }
            }
            if (abbreviationLength != end - start) {
                to.append('\u2026');
            }
        }

        private static int abbreviationLength(String text, int start, int end, FontMetrics metrics, int maxWidth, boolean replaceSeparators) {
            if (metrics.charWidth('m') * (end - start) <= maxWidth) {
                return end - start;
            }
            int abbrWidth = metrics.charWidth('\u2026');
            int abbrLength = 0;
            CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text, start, end);
            LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
            while (!lt.atEnd()) {
                int i = 0;
                while (i < lt.getLength()) {
                    if ((abbrWidth += metrics.charWidth(subSeq.charAt(lt.getOffset() + i))) >= maxWidth) {
                        return abbrLength;
                    }
                    ++i;
                    ++abbrLength;
                }
                if (replaceSeparators && lt.getLineSeparatorLength() != 0) {
                    if ((abbrWidth += metrics.charWidth('\u23ce')) >= maxWidth) {
                        return abbrLength;
                    }
                    abbrLength += lt.getLineSeparatorLength();
                }
                lt.advance();
            }
            return abbrLength;
        }
    }

    public static class SimpleRendererComponent
    extends RendererComponent
    implements Disposable {
        public SimpleRendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            super(project, fileType, inheritFontFromLaF);
        }

        @Override
        public void setText(String text) {
            this.setTextToEditor(text);
        }
    }

    public static abstract class RendererComponent
    extends CellRendererPanel
    implements Disposable {
        private final EditorEx myEditor;
        private final EditorTextField myTextField;
        protected TextAttributes myTextAttributes;
        private boolean mySelected;

        public RendererComponent(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            Pair<EditorTextField, EditorEx> pair = RendererComponent.createEditor(project, fileType, inheritFontFromLaF);
            this.myTextField = (EditorTextField)pair.first;
            this.myEditor = (EditorEx)pair.second;
            this.add(this.myEditor.getContentComponent());
        }

        public EditorEx getEditor() {
            return this.myEditor;
        }

        @NotNull
        private static Pair<EditorTextField, EditorEx> createEditor(Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
            EditorTextField field = new EditorTextField(new MyDocument(), project, fileType, false, false);
            field.setSupplementary(true);
            field.setFontInheritedFromLAF(inheritFontFromLaF);
            field.addNotify();
            EditorEx editor = (EditorEx)ObjectUtils.assertNotNull((Object)field.getEditor());
            editor.setRendererMode(true);
            editor.setColorsScheme(editor.createBoundColorSchemeDelegate(null));
            editor.getSettings().setCaretRowShown(false);
            editor.getScrollPane().setBorder(null);
            Pair pair = Pair.create((Object)field, (Object)editor);
            if (pair == null) {
                RendererComponent.$$$reportNull$$$0(0);
            }
            return pair;
        }

        public void setText(String text, @Nullable TextAttributes textAttributes, boolean selected) {
            this.myTextAttributes = textAttributes;
            this.mySelected = selected;
            this.setText(text);
        }

        public abstract void setText(String var1);

        @Override
        public void setBackground(Color bg) {
            if (this.myEditor != null) {
                this.myEditor.setBackgroundColor(bg);
            }
            super.setBackground(bg);
        }

        public void dispose() {
            this.remove(this.myEditor.getContentComponent());
            this.myTextField.removeNotify();
        }

        protected void setTextToEditor(String text) {
            this.myEditor.getMarkupModel().removeAllHighlighters();
            this.myEditor.getDocument().setText(text);
            ((EditorImpl)this.myEditor).resetSizes();
            this.myEditor.getHighlighter().setText((CharSequence)text);
            if (this.myTextAttributes != null) {
                this.myEditor.getMarkupModel().addRangeHighlighter(0, this.myEditor.getDocument().getTextLength(), 3000, this.myTextAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            ((EditorImpl)this.myEditor).setPaintSelection(this.mySelected);
            SelectionModel selectionModel = this.myEditor.getSelectionModel();
            selectionModel.setSelection(0, this.mySelected ? this.myEditor.getDocument().getTextLength() : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/EditorTextFieldCellRenderer$RendererComponent", "createEditor"));
        }
    }
}

