/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogProgress
implements Disposable {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<ProgressListener> myListeners = ContainerUtil.newArrayList();
    @NotNull
    private final Set<ProgressIndicator> myTasksWithVisibleProgress = ContainerUtil.newHashSet();
    @NotNull
    private final Set<ProgressIndicator> myTasksWithSilentProgress = ContainerUtil.newHashSet();

    @NotNull
    public ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.createProgressIndicator(true);
        if (progressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(0);
        }
        return progressIndicator;
    }

    @NotNull
    public ProgressIndicator createProgressIndicator(boolean visible) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
            if (emptyProgressIndicator == null) {
                VcsLogProgress.$$$reportNull$$$0(1);
            }
            return emptyProgressIndicator;
        }
        VcsLogProgressIndicator vcsLogProgressIndicator = new VcsLogProgressIndicator(visible);
        if (vcsLogProgressIndicator == null) {
            VcsLogProgress.$$$reportNull$$$0(2);
        }
        return vcsLogProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressIndicatorListener(@NotNull ProgressListener listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.add(listener2);
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, () -> {
                    if (listener2 == null) {
                        VcsLogProgress.$$$reportNull$$$0(9);
                    }
                    this.removeProgressIndicatorListener(listener2);
                });
            }
            if (this.isRunning()) {
                ApplicationManager.getApplication().invokeLater(listener2::progressStarted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressIndicatorListener(@NotNull ProgressListener listener2) {
        if (listener2 == null) {
            VcsLogProgress.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myListeners.remove(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myTasksWithVisibleProgress.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void started(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.add(indicator);
                if (this.myTasksWithVisibleProgress.size() == 1) {
                    this.fireNotification(ProgressListener::progressStarted);
                }
            } else {
                this.myTasksWithSilentProgress.add(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(@NotNull VcsLogProgressIndicator indicator) {
        if (indicator == null) {
            VcsLogProgress.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (indicator.isVisible()) {
                this.myTasksWithVisibleProgress.remove(indicator);
                if (this.myTasksWithVisibleProgress.isEmpty()) {
                    this.fireNotification(ProgressListener::progressStopped);
                }
            } else {
                this.myTasksWithSilentProgress.remove(indicator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotification(@NotNull Consumer<ProgressListener> action) {
        if (action == null) {
            VcsLogProgress.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList list2 = ContainerUtil.newArrayList(this.myListeners);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (action == null) {
                    VcsLogProgress.$$$reportNull$$$0(8);
                }
                list2.forEach(action);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (ProgressIndicator indicator : this.myTasksWithVisibleProgress) {
                indicator.cancel();
            }
            for (ProgressIndicator indicator : this.myTasksWithSilentProgress) {
                indicator.cancel();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogProgress";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProgressIndicatorListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeProgressIndicatorListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "started";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireNotification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fireNotification$1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addProgressIndicatorListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProgressListener {
        public void progressStarted();

        public void progressStopped();
    }

    private class VcsLogProgressIndicator
    extends AbstractProgressIndicatorBase {
        private final boolean myVisible;

        private VcsLogProgressIndicator(boolean visible) {
            this.myVisible = visible;
        }

        @Override
        public synchronized void start() {
            super.start();
            VcsLogProgress.this.started(this);
        }

        @Override
        public synchronized void stop() {
            super.stop();
            VcsLogProgress.this.stopped(this);
        }

        public boolean isVisible() {
            return this.myVisible;
        }
    }
}

