/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrintElementGenerator
implements PrintElementGenerator {
    @NotNull
    protected final LinearGraph myLinearGraph;
    @NotNull
    protected final PrintElementManager myPrintElementManager;

    protected AbstractPrintElementGenerator(@NotNull LinearGraph linearGraph, @NotNull PrintElementManager printElementManager) {
        if (linearGraph == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(0);
        }
        if (printElementManager == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(1);
        }
        this.myLinearGraph = linearGraph;
        this.myPrintElementManager = printElementManager;
    }

    @Override
    @NotNull
    public Collection<PrintElementWithGraphElement> getPrintElements(int rowIndex) {
        RowElementType rowElementType;
        ArrayList<PrintElementWithGraphElement> result2 = new ArrayList<PrintElementWithGraphElement>();
        Collection<SimpleRowElement> simpleRowElements = this.getSimpleRowElements(rowIndex);
        HashMap arrows = ContainerUtil.newHashMap();
        for (SimpleRowElement rowElement : simpleRowElements) {
            if (rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            arrows.put((GraphEdge)rowElement.myElement, rowElement);
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.DOWN_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.DOWN_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result2.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.DOWN, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        if (rowIndex > 0) {
            for (ShortEdge shortEdge : this.getDownShortEdges(rowIndex - 1)) {
                rowElementType = RowElementType.NODE;
                if (arrows.get(shortEdge.myEdge) != null && RowElementType.UP_ARROW.equals((Object)((SimpleRowElement)arrows.get((Object)shortEdge.myEdge)).myType)) {
                    rowElementType = RowElementType.UP_ARROW;
                    arrows.remove(shortEdge.myEdge);
                }
                result2.add(this.createEdgePrintElement(rowIndex, shortEdge, EdgePrintElement.Type.UP, !rowElementType.equals((Object)RowElementType.NODE)));
            }
        }
        for (SimpleRowElement arrow : arrows.values()) {
            result2.add(new TerminalEdgePrintElement(rowIndex, arrow.myPosition, arrow.myType == RowElementType.UP_ARROW ? EdgePrintElement.Type.UP : EdgePrintElement.Type.DOWN, (GraphEdge)arrow.myElement, this.myPrintElementManager));
        }
        for (SimpleRowElement rowElement : simpleRowElements) {
            if (!rowElement.myType.equals((Object)RowElementType.NODE)) continue;
            result2.add(this.createSimplePrintElement(rowIndex, rowElement));
        }
        ArrayList<PrintElementWithGraphElement> arrayList = result2;
        if (arrayList == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private SimplePrintElementImpl createSimplePrintElement(int rowIndex, @NotNull SimpleRowElement rowElement) {
        if (rowElement == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(3);
        }
        SimplePrintElementImpl simplePrintElementImpl = new SimplePrintElementImpl(rowIndex, rowElement.myPosition, rowElement.myElement, this.myPrintElementManager);
        if (simplePrintElementImpl == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(4);
        }
        return simplePrintElementImpl;
    }

    @NotNull
    private EdgePrintElementImpl createEdgePrintElement(int rowIndex, @NotNull ShortEdge shortEdge, @NotNull EdgePrintElement.Type type, boolean hasArrow) {
        int positionInOtherRow;
        int positionInCurrentRow;
        if (shortEdge == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(5);
        }
        if (type == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(6);
        }
        if (type == EdgePrintElement.Type.DOWN) {
            positionInCurrentRow = shortEdge.myUpPosition;
            positionInOtherRow = shortEdge.myDownPosition;
        } else {
            positionInCurrentRow = shortEdge.myDownPosition;
            positionInOtherRow = shortEdge.myUpPosition;
        }
        EdgePrintElementImpl edgePrintElementImpl = new EdgePrintElementImpl(rowIndex, positionInCurrentRow, positionInOtherRow, type, shortEdge.myEdge, hasArrow, this.myPrintElementManager);
        if (edgePrintElementImpl == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(7);
        }
        return edgePrintElementImpl;
    }

    @Override
    @NotNull
    public PrintElementWithGraphElement withGraphElement(@NotNull PrintElement printElement) {
        if (printElement == null) {
            AbstractPrintElementGenerator.$$$reportNull$$$0(8);
        }
        if (printElement instanceof PrintElementWithGraphElement) {
            PrintElementWithGraphElement printElementWithGraphElement = (PrintElementWithGraphElement)printElement;
            if (printElementWithGraphElement == null) {
                AbstractPrintElementGenerator.$$$reportNull$$$0(9);
            }
            return printElementWithGraphElement;
        }
        int rowIndex = printElement.getRowIndex();
        for (PrintElementWithGraphElement printElementWithGE : this.getPrintElements(rowIndex)) {
            if (!printElementWithGE.equals(printElement)) continue;
            PrintElementWithGraphElement printElementWithGraphElement = printElementWithGE;
            if (printElementWithGraphElement == null) {
                AbstractPrintElementGenerator.$$$reportNull$$$0(10);
            }
            return printElementWithGraphElement;
        }
        throw new IllegalStateException("Not found graphElement for this printElement: " + printElement);
    }

    @NotNull
    protected abstract Collection<ShortEdge> getDownShortEdges(int var1);

    @NotNull
    protected abstract Collection<SimpleRowElement> getSimpleRowElements(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElementManager";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortEdge";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrintElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimplePrintElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdgePrintElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withGraphElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSimplePrintElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEdgePrintElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withGraphElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum RowElementType {
        NODE,
        UP_ARROW,
        DOWN_ARROW;

    }

    protected static class SimpleRowElement {
        @NotNull
        public final GraphElement myElement;
        @NotNull
        public final RowElementType myType;
        public final int myPosition;

        public SimpleRowElement(@NotNull GraphElement element, @NotNull RowElementType type, int position) {
            if (element == null) {
                SimpleRowElement.$$$reportNull$$$0(0);
            }
            if (type == null) {
                SimpleRowElement.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myPosition = position;
            this.myType = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$SimpleRowElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ShortEdge {
        @NotNull
        public final GraphEdge myEdge;
        public final int myUpPosition;
        public final int myDownPosition;

        public ShortEdge(@NotNull GraphEdge edge, int upPosition, int downPosition) {
            if (edge == null) {
                ShortEdge.$$$reportNull$$$0(0);
            }
            this.myEdge = edge;
            this.myUpPosition = upPosition;
            this.myDownPosition = downPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/AbstractPrintElementGenerator$ShortEdge", "<init>"));
        }
    }
}

