/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VcsRoot rootObject = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(path);
        if (rootObject == null) {
            return false;
        }
        VirtualFile root = rootObject.getPath();
        AbstractVcs vcs = rootObject.getVcs();
        if (vcs == null || root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project).getDataManager();
        if (dataManager == null || !dataManager.getRoots().contains(root) || dataManager.getIndex().getDataGetter() == null) {
            return false;
        }
        List<Object> allLogProviders = Arrays.asList(Extensions.getExtensions((ExtensionPointName)VcsLogProvider.LOG_PROVIDER_EP, (AreaInstance)project));
        VcsLogProvider provider = (VcsLogProvider)ContainerUtil.find(allLogProviders, p -> p.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod()));
        if (provider == null) {
            return false;
        }
        return (Boolean)VcsLogProperties.get((VcsLogProvider)provider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING);
    }

    public void showFileHistory(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(3);
        }
        if (!VcsLogContentUtil.findAndSelectContent(project, FileHistoryUi.class, ui -> {
            if (path == null) {
                VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(4);
            }
            return ui.getPath().equals(path);
        })) {
            VcsLogManager logManager = VcsProjectLog.getInstance(project).getLogManager();
            assert (logManager != null);
            VcsLogContentUtil.openLogTab(project, logManager, TAB_NAME, path.getName(), new FileHistoryUiFactory(path));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowFileHistory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showFileHistory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showFileHistory$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

