/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.HashSet;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerEvaluator;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.pydev.PyStackFrame");
    private static final Object STACK_FRAME_EQUALITY_OBJECT = new Object();
    public static final String DOUBLE_UNDERSCORE = "__";
    public static final String RETURN_VALUES_GROUP_NAME = "Return Values";
    public static final String SPECIAL_VARIABLES_GROUP_NAME = "Special Variables";
    public static final HashSet<String> HIDE_TYPES = new HashSet(Arrays.asList("function", "type", "classobj", "module"));
    public static final int DUNDER_VALUES_IND = 0;
    public static final int SPECIAL_TYPES_IND = 1;
    public static final int IPYTHON_VALUES_IND = 2;
    public static final int NUMBER_OF_GROUPS = 3;
    private Project myProject;
    private final PyFrameAccessor myDebugProcess;
    private final PyStackFrameInfo myFrameInfo;
    private final XSourcePosition myPosition;

    public PyStackFrame(@NotNull Project project, @NotNull PyFrameAccessor debugProcess, @NotNull PyStackFrameInfo frameInfo, XSourcePosition position) {
        if (project == null) {
            PyStackFrame.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            PyStackFrame.$$$reportNull$$$0(1);
        }
        if (frameInfo == null) {
            PyStackFrame.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDebugProcess = debugProcess;
        this.myFrameInfo = frameInfo;
        this.myPosition = position;
    }

    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    public XDebuggerEvaluator getEvaluator() {
        return new PyDebuggerEvaluator(this.myProject, this.myDebugProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            PyStackFrame.$$$reportNull$$$0(3);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
        if (this.myPosition == null) {
            component.append("<frame not available>", SimpleTextAttributes.GRAY_ATTRIBUTES);
            return;
        }
        boolean isExternal = true;
        VirtualFile file2 = this.myPosition.getFile();
        AccessToken lock = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                isExternal = !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file2);
            }
        }
        finally {
            lock.finish();
        }
        component.append(this.myFrameInfo.getName(), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(", ", PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(this.myPosition.getFile().getName(), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(":", PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
        component.append(Integer.toString(this.myPosition.getLine() + 1), PyStackFrame.gray(SimpleTextAttributes.REGULAR_ATTRIBUTES, isExternal));
    }

    private static SimpleTextAttributes gray(SimpleTextAttributes attributes, boolean gray) {
        if (!gray) {
            return attributes;
        }
        return PyStackFrame.getGrayAttributes(attributes);
    }

    protected static SimpleTextAttributes getGrayAttributes(SimpleTextAttributes attributes) {
        return (attributes.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    private boolean isDebugVariableViewVisible() {
        if (this.myDebugProcess instanceof PyDebugProcess) {
            RunnerLayoutUi ui = ((PyDebugProcess)this.myDebugProcess).getSession().getUI();
            Content variablesView = null;
            if (ui != null) {
                variablesView = ui.getContentManager().findContent(XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]));
            }
            return variablesView != null;
        }
        return true;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(4);
        }
        if (node.isObsolete() || !this.isDebugVariableViewVisible()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (node == null) {
                PyStackFrame.$$$reportNull$$$0(8);
            }
            try {
                boolean cached = this.myDebugProcess.isCurrentFrameCached();
                XValueChildrenList values = this.myDebugProcess.loadFrame();
                if (!node.isObsolete()) {
                    this.addChildren(node, values);
                }
                if (values != null && !cached) {
                    PyDebugValue.getAsyncValues((PyFrameAccessor)this.myDebugProcess, (XValueChildrenList)values);
                }
            }
            catch (PyDebuggerException e) {
                if (!node.isObsolete()) {
                    node.setErrorMessage("Unable to display frame variables");
                }
                LOG.warn((Throwable)e);
            }
        });
    }

    protected void addChildren(@NotNull XCompositeNode node, @Nullable XValueChildrenList children2) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(5);
        }
        if (children2 == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        XValueChildrenList filteredChildren = new XValueChildrenList();
        HashMap<String, XValue> returnedValues = new HashMap<String, XValue>();
        ArrayList<Map<String, XValue>> specialValuesGroups = new ArrayList<Map<String, XValue>>();
        IntStream.range(0, 3).mapToObj(i -> new HashMap()).forEach(specialValuesGroups::add);
        boolean isSpecialEmpty = true;
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            XValue value = children2.getValue(i2);
            String name = children2.getName(i2);
            if (!(value instanceof PyDebugValue)) continue;
            PyDebugValue pyValue = (PyDebugValue)value;
            if (pyValue.isReturnedVal() && debuggerSettings.isWatchReturnValues()) {
                returnedValues.put(name, value);
                continue;
            }
            if (!debuggerSettings.isSimplifiedView()) {
                filteredChildren.add(name, value);
                continue;
            }
            int groupIndex = -1;
            if (name.startsWith(DOUBLE_UNDERSCORE) && name.endsWith(DOUBLE_UNDERSCORE) && name.length() > 4) {
                groupIndex = 0;
            } else if (pyValue.isIPythonHidden()) {
                groupIndex = 2;
            } else if (HIDE_TYPES.contains((Object)pyValue.getType())) {
                groupIndex = 1;
            }
            if (groupIndex > -1) {
                specialValuesGroups.get(groupIndex).put(name, value);
                isSpecialEmpty = false;
                continue;
            }
            filteredChildren.add(name, value);
        }
        node.addChildren(filteredChildren, returnedValues.isEmpty() && isSpecialEmpty);
        if (!returnedValues.isEmpty()) {
            PyStackFrame.addReturnedValuesGroup(node, returnedValues);
        }
        if (!isSpecialEmpty) {
            PyStackFrame.addSpecialValuesGroup(node, specialValuesGroups);
        }
    }

    private static void addReturnedValuesGroup(@NotNull XCompositeNode node, final Map<String, XValue> returnedValues) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(6);
        }
        ArrayList group = Lists.newArrayList();
        group.add(new XValueGroup(RETURN_VALUES_GROUP_NAME){

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                XValueChildrenList list2 = new XValueChildrenList();
                for (Map.Entry entry : returnedValues.entrySet()) {
                    list2.add((String)entry.getKey() + "()", (XValue)entry.getValue());
                }
                node.addChildren(list2, true);
            }

            @Nullable
            public Icon getIcon() {
                return AllIcons.Debugger.WatchLastReturnValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyStackFrame$1", "computeChildren"));
            }
        });
        node.addChildren(XValueChildrenList.topGroups((List)group), true);
    }

    private static void addSpecialValuesGroup(@NotNull XCompositeNode node, final List<Map<String, XValue>> specialValuesGroups) {
        if (node == null) {
            PyStackFrame.$$$reportNull$$$0(7);
        }
        ArrayList group = Lists.newArrayList();
        group.add(new XValueGroup(SPECIAL_VARIABLES_GROUP_NAME){

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                XValueChildrenList list2 = new XValueChildrenList();
                for (Map group : specialValuesGroups) {
                    for (Map.Entry entry : group.entrySet()) {
                        list2.add((String)entry.getKey(), (XValue)entry.getValue());
                    }
                }
                node.addChildren(list2, true);
            }

            @Nullable
            public Icon getIcon() {
                return PythonIcons.Python.Debug.SpecialVar;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/PyStackFrame$2", "computeChildren"));
            }
        });
        node.addChildren(XValueChildrenList.topGroups((List)group), true);
    }

    public String getThreadId() {
        return this.myFrameInfo.getThreadId();
    }

    public String getFrameId() {
        return this.myFrameInfo.getId();
    }

    public String getThreadFrameId() {
        return this.myFrameInfo.getThreadId() + ":" + this.myFrameInfo.getId();
    }

    public String getFrameName() {
        return this.myFrameInfo.getName();
    }

    protected XSourcePosition getPosition() {
        return this.myPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyStackFrame";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addReturnedValuesGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSpecialValuesGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$computeChildren$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

