/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.google.common.collect.Lists;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStaticCallHierarchyUtil {
    public static Collection<PsiElement> getCallees(@NotNull PyElement element) {
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(0);
        }
        final ArrayList callees = Lists.newArrayList();
        PyRecursiveElementVisitor visitor2 = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyParameterList(PyParameterList node) {
            }

            @Override
            public void visitPyLambdaExpression(PyLambdaExpression node) {
            }

            @Override
            public void visitPyFunction(PyFunction innerFunction) {
                for (PyParameter parameter : innerFunction.getParameterList().getParameters()) {
                    PyExpression defaultValue = parameter.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue.accept(this);
                }
            }

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                super.visitPyCallExpression(node);
                StreamEx.of(node.multiResolveCalleeFunction(PyResolveContext.defaultContext())).select(PyFunction.class).forEach(callees::add);
            }
        };
        visitor2.visitElement((PsiElement)element);
        return callees;
    }

    public static Collection<PsiElement> getCallers(@NotNull PyElement pyElement) {
        if (pyElement == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(1);
        }
        ArrayList callers = Lists.newArrayList();
        Collection<UsageInfo> usages = PyStaticCallHierarchyUtil.findUsages((PsiElement)pyElement);
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            element = element.getParent();
            while (element instanceof PyParenthesizedExpression) {
                element = element.getParent();
            }
            if (!(element instanceof PyCallExpression)) continue;
            PsiElement caller = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyParameterList.class, PyFunction.class});
            if (caller instanceof PyFunction) {
                callers.add(caller);
                continue;
            }
            if (!(caller instanceof PyParameterList)) continue;
            PsiElement innerFunction = PsiTreeUtil.getParentOfType((PsiElement)caller, PyFunction.class);
            PsiElement outerFunction = PsiTreeUtil.getParentOfType((PsiElement)innerFunction, PyFunction.class);
            if (innerFunction == null || outerFunction == null) continue;
            callers.add(outerFunction);
        }
        return callers;
    }

    private static Collection<UsageInfo> findUsages(@NotNull PsiElement element) {
        FindUsagesHandler handler2;
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(2);
        }
        if ((handler2 = PyStaticCallHierarchyUtil.createFindUsageHandler(element)) == null) {
            return Lists.newArrayList();
        }
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler2.getPrimaryElements(), (Object[])handler2.getSecondaryElements());
        FindUsagesOptions options = handler2.getFindUsagesOptions(null);
        for (PsiElement psiElement : psiElements) {
            handler2.processElementUsages(psiElement, (Processor<UsageInfo>)processor2, options);
        }
        return processor2.getResults();
    }

    @Nullable
    private static FindUsagesHandler createFindUsageHandler(@NotNull PsiElement element) {
        if (element == null) {
            PyStaticCallHierarchyUtil.$$$reportNull$$$0(3);
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), null);
            Collection superMethods = PySuperMethodsSearch.search((PyFunction)element, true, context).findAll();
            if (superMethods.size() > 0 && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyStaticCallHierarchyUtil.isInObject((PyFunction)next)) {
                ArrayList allMethods = Lists.newArrayList();
                allMethods.add(element);
                allMethods.addAll(superMethods);
                return new PyFunctionFindUsagesHandler(element, allMethods);
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        return null;
    }

    private static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallees";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsageHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

