/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.requirement;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersion;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRequirementVersionSpec {
    @NotNull
    private final PyRequirementRelation myRelation;
    @Nullable
    private final PyRequirementVersion myParsedVersion;
    @NotNull
    private final String myVersion;
    @NotNull
    private final Comparator<String> myVersionComparator;

    public PyRequirementVersionSpec(@NotNull PyRequirementRelation relation, @NotNull PyRequirementVersion version) {
        if (relation == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(0);
        }
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(1);
        }
        this(relation, version, version.getPresentableText(), PackageVersionComparator.VERSION_COMPARATOR);
    }

    public PyRequirementVersionSpec(@NotNull String version) {
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(2);
        }
        this(PyRequirementRelation.STR_EQ, null, version, PackageVersionComparator.VERSION_COMPARATOR);
    }

    private PyRequirementVersionSpec(@NotNull PyRequirementRelation relation, @Nullable PyRequirementVersion parsedVersion, @NotNull String version, @NotNull Comparator<String> versionComparator) {
        if (relation == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(3);
        }
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(4);
        }
        if (versionComparator == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(5);
        }
        this.myRelation = relation;
        this.myParsedVersion = parsedVersion;
        this.myVersion = version;
        this.myVersionComparator = versionComparator;
    }

    @Deprecated
    @NotNull
    public PyRequirementVersionSpec withVersionComparator(@NotNull Comparator<String> comparator2) {
        if (comparator2 == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(6);
        }
        PyRequirementVersionSpec pyRequirementVersionSpec = new PyRequirementVersionSpec(this.myRelation, this.myParsedVersion, this.myVersion, comparator2);
        if (pyRequirementVersionSpec == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(7);
        }
        return pyRequirementVersionSpec;
    }

    public String toString() {
        return (Object)((Object)this.myRelation) + this.myVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyRequirementVersionSpec spec = (PyRequirementVersionSpec)o;
        return this.myRelation == spec.myRelation && this.myVersion.equals(spec.myVersion);
    }

    public int hashCode() {
        return 31 * this.myRelation.hashCode() + this.myVersion.hashCode();
    }

    @NotNull
    public PyRequirementRelation getRelation() {
        PyRequirementRelation pyRequirementRelation = this.myRelation;
        if (pyRequirementRelation == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(8);
        }
        return pyRequirementRelation;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean matches(@NotNull String version) {
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(10);
        }
        switch (this.myRelation) {
            case LT: {
                return this.myVersionComparator.compare(version, this.myVersion) < 0;
            }
            case LTE: {
                return this.myVersionComparator.compare(version, this.myVersion) <= 0;
            }
            case GT: {
                return this.myVersionComparator.compare(version, this.myVersion) > 0;
            }
            case GTE: {
                return this.myVersionComparator.compare(version, this.myVersion) >= 0;
            }
            case EQ: {
                Objects.requireNonNull(this.myParsedVersion);
                Pair<String, String> publicAndLocalVersions = PyRequirementVersionSpec.splitIntoPublicAndLocalVersions(this.myParsedVersion);
                Pair<String, String> otherPublicAndLocalVersions = PyRequirementVersionSpec.splitIntoPublicAndLocalVersions(version);
                boolean publicVersionsAreSame = this.myVersionComparator.compare((String)otherPublicAndLocalVersions.first, (String)publicAndLocalVersions.first) == 0;
                return publicVersionsAreSame && (((String)publicAndLocalVersions.second).isEmpty() || ((String)otherPublicAndLocalVersions.second).equals(publicAndLocalVersions.second));
            }
            case NE: {
                return this.myVersionComparator.compare(version, this.myVersion) != 0;
            }
            case COMPATIBLE: {
                Objects.requireNonNull(this.myParsedVersion);
                return new PyRequirementVersionSpec(PyRequirementRelation.GTE, this.myParsedVersion).matches(version) && new PyRequirementVersionSpec(PyRequirementRelation.EQ, PyRequirementVersionSpec.toEqPartOfCompatibleRelation(this.myParsedVersion)).matches(version);
            }
            case STR_EQ: {
                return version.equals(this.myVersion);
            }
        }
        return false;
    }

    @NotNull
    private static Pair<String, String> splitIntoPublicAndLocalVersions(@NotNull PyRequirementVersion version) {
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(11);
        }
        PyRequirementVersion withoutLocal = new PyRequirementVersion(version.getEpoch(), version.getRelease(), version.getPre(), version.getPost(), version.getDev(), null);
        Pair.NonNull nonNull = Pair.createNonNull((Object)withoutLocal.getPresentableText(), (Object)StringUtil.notNullize((String)version.getLocal()));
        if (nonNull == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(12);
        }
        return nonNull;
    }

    @NotNull
    private static Pair<String, String> splitIntoPublicAndLocalVersions(@NotNull String version) {
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(13);
        }
        String[] publicAndLocalVersions = version.split("\\+", 2);
        String publicVersion = publicAndLocalVersions[0];
        String localVersion = publicAndLocalVersions.length == 1 ? "" : publicAndLocalVersions[1];
        Pair.NonNull nonNull = Pair.createNonNull((Object)publicVersion, (Object)localVersion);
        if (nonNull == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(14);
        }
        return nonNull;
    }

    @NotNull
    private static PyRequirementVersion toEqPartOfCompatibleRelation(@NotNull PyRequirementVersion version) {
        String release;
        int lastPoint;
        if (version == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(15);
        }
        if ((lastPoint = (release = version.getRelease()).lastIndexOf(".")) == -1) {
            PyRequirementVersion pyRequirementVersion = version;
            if (pyRequirementVersion == null) {
                PyRequirementVersionSpec.$$$reportNull$$$0(16);
            }
            return pyRequirementVersion;
        }
        PyRequirementVersion pyRequirementVersion = new PyRequirementVersion(version.getEpoch(), release.substring(0, lastPoint) + "*", null, null, null, null);
        if (pyRequirementVersion == null) {
            PyRequirementVersionSpec.$$$reportNull$$$0(17);
        }
        return pyRequirementVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionComparator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/requirement/PyRequirementVersionSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/requirement/PyRequirementVersionSpec";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionComparator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIntoPublicAndLocalVersions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toEqPartOfCompatibleRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withVersionComparator";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitIntoPublicAndLocalVersions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toEqPartOfCompatibleRelation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

