/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyKeywordArgumentProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeywordArgumentCompletionUtil {
    public static void collectFunctionArgNames(PyElement element, List<LookupElement> ret, @NotNull TypeEvalContext context) {
        PyExpression callee;
        PyCallExpression callExpr;
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(0);
        }
        if ((callExpr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) != null && (callee = callExpr.getCallee()) instanceof PyReferenceExpression && element.getParent() == callExpr.getArgumentList()) {
            PyNamedTupleType namedTupleType;
            PyFunction init;
            PyElement def = KeywordArgumentCompletionUtil.getElementByType(context, callee);
            if (def == null) {
                def = KeywordArgumentCompletionUtil.getElementByChain(context, (PyReferenceExpression)callee);
            }
            if (def instanceof PyCallable) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants((PyCallable)def, callExpr, ret);
            } else if (def instanceof PyClass && (init = ((PyClass)def).findMethodByName("__init__", true, null)) != null) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants(init, callExpr, ret);
            }
            PyType calleeType = context.getType(callee);
            PyUnionType unionType = PyUtil.as(calleeType, PyUnionType.class);
            if (unionType != null) {
                KeywordArgumentCompletionUtil.fetchCallablesFromUnion(ret, callExpr, unionType, context);
            }
            if ((namedTupleType = PyUtil.as(calleeType, PyNamedTupleType.class)) != null) {
                for (String name : namedTupleType.getFields().keySet()) {
                    ret.add(PyUtil.createNamedParameterLookup(name, element.getProject()));
                }
            }
        }
    }

    @Nullable
    private static PyElement getElementByType(@NotNull TypeEvalContext context, @NotNull PyExpression callee) {
        PyType pyType;
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(1);
        }
        if (callee == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(2);
        }
        if ((pyType = context.getType(callee)) instanceof PyFunctionType) {
            return ((PyFunctionType)pyType).getCallable();
        }
        if (pyType instanceof PyClassType) {
            return ((PyClassType)pyType).getPyClass();
        }
        return null;
    }

    private static PsiElement getElementByChain(@NotNull TypeEvalContext context, PyReferenceExpression callee) {
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(3);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
        QualifiedResolveResult result2 = callee.followAssignmentsChain(resolveContext);
        return result2.getElement();
    }

    private static void fetchCallablesFromUnion(@NotNull List<LookupElement> ret, @NotNull PyCallExpression callExpr, @NotNull PyUnionType unionType, @NotNull TypeEvalContext context) {
        if (ret == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(4);
        }
        if (callExpr == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(5);
        }
        if (unionType == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(7);
        }
        for (PyType memberType : unionType.getMembers()) {
            List<PyCallableParameter> callableParameters;
            PyFunctionType type;
            if (memberType instanceof PyUnionType) {
                KeywordArgumentCompletionUtil.fetchCallablesFromUnion(ret, callExpr, (PyUnionType)memberType, context);
            }
            if (memberType instanceof PyFunctionType && (type = (PyFunctionType)memberType).isCallable()) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants(type.getCallable(), callExpr, ret);
            }
            if (!(memberType instanceof PyCallableType) || (callableParameters = ((PyCallableType)memberType).getParameters(context)) == null) continue;
            KeywordArgumentCompletionUtil.fetchCallablesFromCallableType(ret, callExpr, callableParameters);
        }
    }

    private static void fetchCallablesFromCallableType(@NotNull List<LookupElement> ret, @NotNull PyCallExpression callExpr, @NotNull Iterable<PyCallableParameter> callableParameters) {
        if (ret == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(8);
        }
        if (callExpr == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(9);
        }
        if (callableParameters == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(10);
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (PyCallableParameter callableParameter : callableParameters) {
            String name = callableParameter.getName();
            if (name == null) continue;
            parameterNames.add(name);
        }
        KeywordArgumentCompletionUtil.addKeywordArgumentVariantsForCallable(callExpr, ret, parameterNames);
    }

    public static void addKeywordArgumentVariants(PyCallable callable, PyCallExpression callExpr, List<LookupElement> ret) {
        KeywordArgumentCompletionUtil.addKeywordArgumentVariants(callable, callExpr, ret, new HashSet<PyCallable>());
    }

    public static void addKeywordArgumentVariants(PyCallable callable, PyCallExpression callExpr, List<LookupElement> ret, Collection<PyCallable> visited) {
        if (visited.contains(callable)) {
            return;
        }
        visited.add(callable);
        TypeEvalContext context = TypeEvalContext.codeCompletion(callable.getProject(), callable.getContainingFile());
        List<PyCallableParameter> parameters = callable.getParameters(context);
        if (callable instanceof PyFunction) {
            KeywordArgumentCompletionUtil.addKeywordArgumentVariantsForFunction(callExpr, ret, visited, (PyFunction)callable, parameters, context);
        } else {
            ArrayList<String> parameterNames = new ArrayList<String>();
            for (PyCallableParameter parameter : parameters) {
                String name = parameter.getName();
                if (name == null) continue;
                parameterNames.add(name);
            }
            KeywordArgumentCompletionUtil.addKeywordArgumentVariantsForCallable(callExpr, ret, parameterNames);
        }
    }

    private static void addKeywordArgumentVariantsForCallable(@NotNull PyCallExpression callExpr, @NotNull List<LookupElement> ret, @NotNull Collection<String> parameterNames) {
        if (callExpr == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(11);
        }
        if (ret == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(12);
        }
        if (parameterNames == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(13);
        }
        for (String parameterName : parameterNames) {
            ret.add(PyUtil.createNamedParameterLookup(parameterName, callExpr.getProject()));
        }
    }

    private static void addKeywordArgumentVariantsForFunction(@NotNull PyCallExpression callExpr, @NotNull List<LookupElement> ret, @NotNull Collection<PyCallable> visited, @NotNull PyFunction function, @NotNull List<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (callExpr == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(14);
        }
        if (ret == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(15);
        }
        if (visited == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(16);
        }
        if (function == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(17);
        }
        if (parameters == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            KeywordArgumentCompletionUtil.$$$reportNull$$$0(19);
        }
        boolean needSelf = function.getContainingClass() != null && function.getModifier() != PyFunction.Modifier.STATICMETHOD;
        KwArgParameterCollector collector = new KwArgParameterCollector(needSelf, ret);
        StreamEx.of(parameters).map(PyCallableParameter::getParameter).nonNull().forEach(parameter -> parameter.accept(collector));
        if (collector.hasKwArgs()) {
            PsiElement superMethod;
            for (PyKeywordArgumentProvider provider : (PyKeywordArgumentProvider[])Extensions.getExtensions(PyKeywordArgumentProvider.EP_NAME)) {
                List<String> arguments = provider.getKeywordArguments(function, callExpr);
                for (String argument : arguments) {
                    ret.add(PyUtil.createNamedParameterLookup(argument, callExpr.getProject()));
                }
            }
            KwArgFromStatementCallCollector fromStatementCallCollector = new KwArgFromStatementCallCollector(ret, collector.getKwArgs());
            function.getStatementList().acceptChildren(fromStatementCallCollector);
            if (fromStatementCallCollector.isKwArgsTransit() && (superMethod = (PsiElement)PySuperMethodsSearch.search(function, context).findFirst()) instanceof PyFunction) {
                KeywordArgumentCompletionUtil.addKeywordArgumentVariants((PyFunction)superMethod, callExpr, ret, visited);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ret";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterNames";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFunctionArgNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementByType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementByChain";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchCallablesFromUnion";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchCallablesFromCallableType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addKeywordArgumentVariantsForCallable";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addKeywordArgumentVariantsForFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class KwArgFromStatementCallCollector
    extends PyElementVisitor {
        private final List<LookupElement> myRet;
        private final PyParameter myKwArgs;
        private boolean kwArgsTransit;

        public KwArgFromStatementCallCollector(List<LookupElement> ret, @NotNull PyParameter kwArgs) {
            if (kwArgs == null) {
                KwArgFromStatementCallCollector.$$$reportNull$$$0(0);
            }
            this.kwArgsTransit = true;
            this.myRet = ret;
            this.myKwArgs = kwArgs;
        }

        @Override
        public void visitPyElement(PyElement node) {
            node.acceptChildren(this);
        }

        @Override
        public void visitPySubscriptionExpression(PySubscriptionExpression node) {
            String operandName = node.getOperand().getName();
            this.processGet(operandName, node.getIndexExpression());
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            block4: {
                block3: {
                    if (!node.isCalleeText("pop", "get", "getattr")) break block3;
                    PyReferenceExpression child = (PyReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)node.getCallee(), PyReferenceExpression.class);
                    if (child == null) break block4;
                    String operandName = child.getName();
                    if (node.getArguments().length > 0) {
                        PyExpression argument = node.getArguments()[0];
                        this.processGet(operandName, argument);
                    }
                    break block4;
                }
                if (node.isCalleeText("__init__")) {
                    this.kwArgsTransit = false;
                    for (PyExpression e : node.getArguments()) {
                        if (!(e instanceof PyStarArgument)) continue;
                        PyStarArgument kw = (PyStarArgument)e;
                        if (!Comparing.equal((String)this.myKwArgs.getName(), (String)kw.getFirstChild().getNextSibling().getText())) continue;
                        this.kwArgsTransit = true;
                        break;
                    }
                }
            }
            super.visitPyCallExpression(node);
        }

        private void processGet(String operandName, PyExpression argument) {
            String name;
            if (Comparing.equal((String)this.myKwArgs.getName(), (String)operandName) && argument instanceof PyStringLiteralExpression && PyNames.isIdentifier(name = ((PyStringLiteralExpression)argument).getStringValue())) {
                this.myRet.add(PyUtil.createNamedParameterLookup(name, argument.getProject()));
            }
        }

        public boolean isKwArgsTransit() {
            return this.kwArgsTransit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kwArgs", "com/jetbrains/python/psi/impl/references/KeywordArgumentCompletionUtil$KwArgFromStatementCallCollector", "<init>"));
        }
    }

    public static class KwArgParameterCollector
    extends PyElementVisitor {
        private int myCount;
        private final boolean myNeedSelf;
        private final List<LookupElement> myRet;
        private boolean myHasSelf = false;
        private boolean myHasKwArgs = false;
        private PyParameter kwArgsParam = null;

        public KwArgParameterCollector(boolean needSelf, List<LookupElement> ret) {
            this.myNeedSelf = needSelf;
            this.myRet = ret;
        }

        @Override
        public void visitPyParameter(PyParameter par) {
            block5: {
                block3: {
                    PyNamedParameter namedParam;
                    block4: {
                        ++this.myCount;
                        if (this.myCount == 1 && this.myNeedSelf) {
                            this.myHasSelf = true;
                            return;
                        }
                        namedParam = par.getAsNamed();
                        if (namedParam == null) break block3;
                        if (namedParam.isKeywordContainer() || namedParam.isPositionalContainer()) break block4;
                        LookupElement item = PyUtil.createNamedParameterLookup(namedParam.getName(), par.getProject());
                        this.myRet.add(item);
                        break block5;
                    }
                    if (!namedParam.isKeywordContainer()) break block5;
                    this.myHasKwArgs = true;
                    this.kwArgsParam = namedParam;
                    break block5;
                }
                PyTupleParameter nestedTParam = par.getAsTuple();
                if (nestedTParam != null) {
                    for (PyParameter inner_par : nestedTParam.getContents()) {
                        inner_par.accept(this);
                    }
                }
            }
        }

        public PyParameter getKwArgs() {
            return this.kwArgsParam;
        }

        public boolean hasKwArgs() {
            return this.myHasKwArgs;
        }
    }
}

