/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;

public class EvaluateCommand
extends AbstractFrameCommand {
    private final String myExpression;
    private final boolean myExecute;
    private final IPyDebugProcess myDebugProcess;
    private final boolean myTrimResult;
    private PyDebugValue myValue = null;
    private String myTempName;

    public EvaluateCommand(RemoteDebugger debugger, String threadId, String frameId, String expression, boolean execute2, boolean trimResult) {
        super(debugger, execute2 ? 115 : 113, threadId, frameId);
        this.myExpression = expression;
        this.myExecute = execute2;
        this.myDebugProcess = debugger.getDebugProcess();
        this.myTrimResult = trimResult;
        this.myTempName = this.myDebugProcess.canSaveToTemp(expression) ? debugger.generateSaveTempName(threadId, frameId) : "";
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myExpression).add(this.myTrimResult).add(this.myTempName);
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            EvaluateCommand.$$$reportNull$$$0(0);
        }
        super.processResponse(response);
        PyDebugValue value = ProtocolParser.parseValue(response.getPayload(), (PyFrameAccessor)this.myDebugProcess);
        this.myValue = new PyDebugValue(value, this.myExecute ? "" : this.myExpression);
        if (!this.myTempName.isEmpty()) {
            this.myValue.setTempName(this.myTempName);
        }
    }

    public PyDebugValue getValue() {
        return this.myValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/jetbrains/python/debugger/pydev/EvaluateCommand", "processResponse"));
    }
}

